/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.commons.Trainer;
import opennlp.tools.ml.AlgorithmType;
import opennlp.tools.ml.EventModelSequenceTrainer;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.SequenceTrainer;
import opennlp.tools.monitoring.DefaultTrainingProgressMonitor;
import opennlp.tools.monitoring.TrainingProgressMonitor;
import opennlp.tools.util.Parameters;
import opennlp.tools.util.TrainingConfiguration;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.ext.ExtensionLoader;
import opennlp.tools.util.ext.ExtensionNotLoadedException;

public class TrainerFactory {
    private static final Map<String, Class<? extends Trainer<TrainingParameters>>> BUILTIN_TRAINERS = new HashMap<String, Class<? extends Trainer<TrainingParameters>>>();

    public static TrainerType getTrainerType(Parameters trainParams) {
        String algorithmValue = trainParams.getStringParameter("Algorithm", null);
        if (algorithmValue == null) {
            return TrainerType.EVENT_MODEL_TRAINER;
        }
        Class<? extends Trainer<TrainingParameters>> trainerClass = BUILTIN_TRAINERS.get(algorithmValue);
        if (trainerClass != null) {
            if (EventTrainer.class.isAssignableFrom(trainerClass)) {
                return TrainerType.EVENT_MODEL_TRAINER;
            }
            if (EventModelSequenceTrainer.class.isAssignableFrom(trainerClass)) {
                return TrainerType.EVENT_MODEL_SEQUENCE_TRAINER;
            }
            if (SequenceTrainer.class.isAssignableFrom(trainerClass)) {
                return TrainerType.SEQUENCE_TRAINER;
            }
        }
        try {
            ExtensionLoader.instantiateExtension(EventTrainer.class, (String)algorithmValue);
            return TrainerType.EVENT_MODEL_TRAINER;
        }
        catch (ExtensionNotLoadedException extensionNotLoadedException) {
            try {
                ExtensionLoader.instantiateExtension(EventModelSequenceTrainer.class, (String)algorithmValue);
                return TrainerType.EVENT_MODEL_SEQUENCE_TRAINER;
            }
            catch (ExtensionNotLoadedException extensionNotLoadedException2) {
                try {
                    ExtensionLoader.instantiateExtension(SequenceTrainer.class, (String)algorithmValue);
                    return TrainerType.SEQUENCE_TRAINER;
                }
                catch (ExtensionNotLoadedException extensionNotLoadedException3) {
                    return null;
                }
            }
        }
    }

    public static SequenceTrainer<TrainingParameters> getSequenceModelTrainer(TrainingParameters trainParams, Map<String, String> reportMap) {
        String trainerType = trainParams.getStringParameter("Algorithm", null);
        if (trainerType != null) {
            SequenceTrainer trainer = BUILTIN_TRAINERS.containsKey(trainerType) ? (SequenceTrainer)TrainerFactory.createBuiltinTrainer(BUILTIN_TRAINERS.get(trainerType)) : (SequenceTrainer)ExtensionLoader.instantiateExtension(SequenceTrainer.class, (String)trainerType);
            trainer.init((Parameters)trainParams, reportMap);
            return trainer;
        }
        throw new IllegalArgumentException("Trainer type couldn't be determined!");
    }

    public static <T> EventModelSequenceTrainer<T, TrainingParameters> getEventModelSequenceTrainer(TrainingParameters trainParams, Map<String, String> reportMap) {
        String trainerType = trainParams.getStringParameter("Algorithm", null);
        if (trainerType != null) {
            EventModelSequenceTrainer trainer = BUILTIN_TRAINERS.containsKey(trainerType) ? (EventModelSequenceTrainer)TrainerFactory.createBuiltinTrainer(BUILTIN_TRAINERS.get(trainerType)) : (EventModelSequenceTrainer)ExtensionLoader.instantiateExtension(EventModelSequenceTrainer.class, (String)trainerType);
            trainer.init((Parameters)trainParams, reportMap);
            return trainer;
        }
        throw new IllegalArgumentException("Trainer type couldn't be determined!");
    }

    public static EventTrainer<TrainingParameters> getEventTrainer(TrainingParameters trainParams, Map<String, String> reportMap) {
        TrainingConfiguration trainingConfiguration = new TrainingConfiguration((TrainingProgressMonitor)new DefaultTrainingProgressMonitor(), null);
        return TrainerFactory.getEventTrainer(trainParams, reportMap, trainingConfiguration);
    }

    public static EventTrainer<TrainingParameters> getEventTrainer(TrainingParameters trainParams, Map<String, String> reportMap, TrainingConfiguration config) {
        String trainerType = trainParams.getStringParameter("Algorithm", Parameters.ALGORITHM_DEFAULT_VALUE);
        EventTrainer trainer = BUILTIN_TRAINERS.containsKey(trainerType) ? (EventTrainer)TrainerFactory.createBuiltinTrainer(BUILTIN_TRAINERS.get(trainerType)) : (EventTrainer)ExtensionLoader.instantiateExtension(EventTrainer.class, (String)trainerType);
        trainer.init((Parameters)trainParams, reportMap, config);
        return trainer;
    }

    public static boolean isValid(Parameters trainParams) {
        String algorithmName = trainParams.getStringParameter("Algorithm", null);
        if (algorithmName != null && !BUILTIN_TRAINERS.containsKey(algorithmName) && TrainerFactory.getTrainerType(trainParams) == null) {
            return false;
        }
        try {
            trainParams.getIntParameter("Cutoff", 5);
            trainParams.getIntParameter("Iterations", 100);
        }
        catch (NumberFormatException e) {
            return false;
        }
        trainParams.getStringParameter("DataIndexer", null);
        return true;
    }

    private static <P extends Parameters, T extends Trainer<P>> T createBuiltinTrainer(Class<? extends Trainer<P>> trainerClass) {
        Trainer<P> theTrainer = null;
        if (trainerClass != null) {
            try {
                Constructor<Trainer<P>> c = trainerClass.getConstructor(new Class[0]);
                theTrainer = c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                String msg = "Could not instantiate the " + trainerClass.getCanonicalName() + ". The initialization threw an exception.";
                throw new IllegalArgumentException(msg, e);
            }
        }
        return (T)theTrainer;
    }

    static {
        for (AlgorithmType tat : AlgorithmType.values()) {
            String clazz = tat.getTrainerClazz();
            try {
                Class<?> c = Class.forName(clazz);
                BUILTIN_TRAINERS.put(tat.getAlgorithmType(), c);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public static enum TrainerType {
        EVENT_MODEL_TRAINER,
        EVENT_MODEL_SEQUENCE_TRAINER,
        SEQUENCE_TRAINER;

    }
}

