/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Objects;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;
import opennlp.tools.util.featuregen.FeatureGeneratorUtil;

public class DefaultNameContextGenerator
implements NameContextGenerator {
    protected AdaptiveFeatureGenerator[] featureGenerators;

    public DefaultNameContextGenerator(AdaptiveFeatureGenerator ... featureGenerators) {
        this.featureGenerators = Objects.requireNonNull(featureGenerators, "Please specify at least one featureGenerator");
    }

    public void addFeatureGenerator(AdaptiveFeatureGenerator generator) {
        AdaptiveFeatureGenerator[] generators = this.featureGenerators;
        this.featureGenerators = new AdaptiveFeatureGenerator[this.featureGenerators.length + 1];
        System.arraycopy(generators, 0, this.featureGenerators, 0, generators.length);
        this.featureGenerators[this.featureGenerators.length - 1] = generator;
    }

    public void updateAdaptiveData(String[] tokens, String[] outcomes) {
        if (tokens != null && outcomes != null && tokens.length != outcomes.length) {
            throw new IllegalArgumentException("The tokens and outcome arrays MUST have the same size!");
        }
        for (AdaptiveFeatureGenerator featureGenerator : this.featureGenerators) {
            featureGenerator.updateAdaptiveData(tokens, outcomes);
        }
    }

    public void clearAdaptiveData() {
        for (AdaptiveFeatureGenerator featureGenerator : this.featureGenerators) {
            featureGenerator.clearAdaptiveData();
        }
    }

    public String[] getContext(int index, String[] tokens, String[] preds, Object[] additionalContext) {
        ArrayList<CallSite> features = new ArrayList<CallSite>();
        for (AdaptiveFeatureGenerator featureGenerator : this.featureGenerators) {
            featureGenerator.createFeatures(features, tokens, index, preds);
        }
        String po = "other";
        String ppo = "other";
        if (preds != null) {
            if (index > 1) {
                ppo = preds[index - 2];
            }
            if (index > 0) {
                po = preds[index - 1];
            }
            features.add((CallSite)((Object)("po=" + po)));
            features.add((CallSite)((Object)("pow=" + po + "," + tokens[index])));
            features.add((CallSite)((Object)("powf=" + po + "," + FeatureGeneratorUtil.tokenFeature(tokens[index]))));
            features.add((CallSite)((Object)("ppo=" + ppo)));
        }
        return features.toArray(new String[0]);
    }
}

