/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange.topic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class TopicNormalizer {
    private static final String STAR_TOKEN = "*";
    private static final String HASH_TOKEN = "#";
    private static final String SEPARATOR = ".";

    private TopicNormalizer() {
    }

    public static String normalize(String routingKey) {
        if (routingKey == null) {
            return "";
        }
        if (!routingKey.contains(HASH_TOKEN) && routingKey.contains(STAR_TOKEN)) {
            return routingKey;
        }
        ArrayList<String> subscriptionList = new ArrayList<String>(Arrays.asList(routingKey.split("\\.")));
        int size = subscriptionList.size();
        for (int index = 0; index < size; ++index) {
            if (index + 1 >= size || !((String)subscriptionList.get(index)).equals(HASH_TOKEN)) continue;
            if (((String)subscriptionList.get(index + 1)).equals(HASH_TOKEN)) {
                subscriptionList.remove(index);
                --size;
                --index;
            }
            if (!((String)subscriptionList.get(index + 1)).equals(STAR_TOKEN)) continue;
            subscriptionList.add(index + 1, (String)subscriptionList.remove(index));
        }
        Iterator iter = subscriptionList.iterator();
        StringBuilder builder = new StringBuilder((String)iter.next());
        while (iter.hasNext()) {
            builder.append(SEPARATOR).append((String)iter.next());
        }
        return builder.toString();
    }
}

