/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging.otlp.internal.metrics;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.MetricReusableDataMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.ResourceMetricsMarshaler;
import io.opentelemetry.exporter.logging.otlp.internal.metrics.OtlpStdoutMetricExporterBuilder;
import io.opentelemetry.exporter.logging.otlp.internal.writer.JsonWriter;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import java.util.Collection;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OtlpStdoutMetricExporter
implements MetricExporter {
    private static final Logger LOGGER = Logger.getLogger(OtlpStdoutMetricExporter.class.getName());
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final Logger logger;
    private final JsonWriter jsonWriter;
    private final boolean wrapperJsonObject;
    private final MemoryMode memoryMode;
    private final Function<Collection<MetricData>, CompletableResultCode> marshaler;
    private final AggregationTemporalitySelector aggregationTemporalitySelector;
    private final DefaultAggregationSelector defaultAggregationSelector;

    OtlpStdoutMetricExporter(Logger logger, JsonWriter jsonWriter, boolean wrapperJsonObject, MemoryMode memoryMode, AggregationTemporalitySelector aggregationTemporalitySelector, DefaultAggregationSelector defaultAggregationSelector) {
        this.logger = logger;
        this.jsonWriter = jsonWriter;
        this.wrapperJsonObject = wrapperJsonObject;
        this.memoryMode = memoryMode;
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        this.defaultAggregationSelector = defaultAggregationSelector;
        this.marshaler = OtlpStdoutMetricExporter.createMarshaler(jsonWriter, memoryMode, wrapperJsonObject);
    }

    public static OtlpStdoutMetricExporterBuilder builder() {
        return new OtlpStdoutMetricExporterBuilder(LOGGER).setOutput(System.out);
    }

    private static Function<Collection<MetricData>, CompletableResultCode> createMarshaler(JsonWriter jsonWriter, MemoryMode memoryMode, boolean wrapperJsonObject) {
        if (wrapperJsonObject) {
            MetricReusableDataMarshaler reusableDataMarshaler = new MetricReusableDataMarshaler(memoryMode, (marshaler, numItems) -> jsonWriter.write((Marshaler)marshaler));
            return arg_0 -> ((MetricReusableDataMarshaler)reusableDataMarshaler).export(arg_0);
        }
        return metrics -> {
            for (ResourceMetricsMarshaler marshaler : ResourceMetricsMarshaler.create((Collection)metrics)) {
                CompletableResultCode resultCode = jsonWriter.write((Marshaler)marshaler);
                if (resultCode.isSuccess()) continue;
                return resultCode;
            }
            return CompletableResultCode.ofSuccess();
        };
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporalitySelector.getAggregationTemporality(instrumentType);
    }

    public Aggregation getDefaultAggregation(InstrumentType instrumentType) {
        return this.defaultAggregationSelector.getDefaultAggregation(instrumentType);
    }

    public MemoryMode getMemoryMode() {
        return this.memoryMode;
    }

    public CompletableResultCode export(Collection<MetricData> metrics) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        return this.marshaler.apply(metrics);
    }

    public CompletableResultCode flush() {
        return this.jsonWriter.flush();
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.INFO, "Calling shutdown() multiple times.");
        } else {
            this.jsonWriter.close();
        }
        return CompletableResultCode.ofSuccess();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpStdoutMetricExporter{", "}");
        joiner.add("jsonWriter=" + this.jsonWriter);
        joiner.add("wrapperJsonObject=" + this.wrapperJsonObject);
        joiner.add("memoryMode=" + this.memoryMode);
        joiner.add("aggregationTemporalitySelector=" + AggregationTemporalitySelector.asString((AggregationTemporalitySelector)this.aggregationTemporalitySelector));
        joiner.add("defaultAggregationSelector=" + DefaultAggregationSelector.asString((DefaultAggregationSelector)this.defaultAggregationSelector));
        return joiner.toString();
    }
}

