/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Arrays;
import java.util.Map;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.DefaultGeodeticCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.datum.DefaultDatumEnsemble;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;

@XmlTransient
public class DefaultGeographicCRS
extends DefaultGeodeticCRS
implements GeographicCRS {
    private static final short[] EPSG_CODES = new short[]{4267, 4269, 4326};
    private static final byte[] CRS_CODES = new byte[]{27, 83, 84};
    private static final long serialVersionUID = 861224913438092335L;

    public DefaultGeographicCRS(Map<String, ?> properties, GeodeticDatum datum, DefaultDatumEnsemble<GeodeticDatum> ensemble, EllipsoidalCS cs) {
        super(properties, datum, ensemble, (CoordinateSystem)cs);
        DefaultGeographicCRS.checkDimension(2, 3, (CoordinateSystem)cs);
    }

    private DefaultGeographicCRS(DefaultGeographicCRS original, ReferenceIdentifier id, AbstractCS cs) {
        super(original, id, cs);
    }

    DefaultGeographicCRS(GeodeticCRS crs) {
        super(crs);
        CoordinateSystem cs = super.getCoordinateSystem();
        if (!(cs instanceof EllipsoidalCS)) {
            throw DefaultGeographicCRS.illegalCoordinateSystemType(cs);
        }
        DefaultGeographicCRS.checkDimension(2, 3, cs);
    }

    protected DefaultGeographicCRS(GeographicCRS crs) {
        super((GeodeticCRS)crs);
    }

    public static DefaultGeographicCRS castOrCopy(GeographicCRS object) {
        return object == null || object instanceof DefaultGeographicCRS ? (DefaultGeographicCRS)object : new DefaultGeographicCRS(object);
    }

    @Override
    public Class<? extends GeographicCRS> getInterface() {
        return GeographicCRS.class;
    }

    public PrimeMeridian getPrimeMeridian() {
        return DatumOrEnsemble.asDatum(this).getPrimeMeridian();
    }

    public Ellipsoid getEllipsoid() {
        return DatumOrEnsemble.asDatum(this).getEllipsoid();
    }

    @Override
    public final GeodeticDatum getDatum() {
        return super.getDatum();
    }

    @Override
    public DefaultDatumEnsemble<GeodeticDatum> getDatumEnsemble() {
        return super.getDatumEnsemble();
    }

    public EllipsoidalCS getCoordinateSystem() {
        return (EllipsoidalCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultGeographicCRS forConvention(AxesConvention convention) {
        return (DefaultGeographicCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(AbstractCS cs) {
        ImmutableIdentifier id = null;
        CoordinateSystemAxis axis = cs.getAxis(0);
        if (axis.getMinimumValue() == -180.0 && axis.getMaximumValue() == 180.0) {
            for (ReferenceIdentifier identifier : super.getIdentifiers()) {
                if (!"EPSG".equals(identifier.getCodeSpace())) continue;
                try {
                    int i = Arrays.binarySearch(EPSG_CODES, Short.parseShort(identifier.getCode()));
                    if (i < 0) continue;
                    id = new ImmutableIdentifier((Citation)Citations.WMS, "CRS", Short.toString(CRS_CODES[i]));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        return new DefaultGeographicCRS(this, (ReferenceIdentifier)id, cs);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        return super.formatTo(formatter);
    }

    private DefaultGeographicCRS() {
    }
}

