/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.alerts;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.fs.FileRef;

public abstract class Alert {
    private final SourcePosition sourcePosition;
    private final String message;
    private final Severity defaultSeverity;

    public Alert(SourcePosition sourcePosition, Severity defaultSeverity, String message) {
        this.sourcePosition = Preconditions.checkNotNull(sourcePosition, "sourcePosition is null");
        this.defaultSeverity = Preconditions.checkNotNull(defaultSeverity, "defaultSeverity is null");
        this.message = Preconditions.checkNotNull(message, "alert message is null");
    }

    public final FileRef getSource() {
        return this.sourcePosition.getSource();
    }

    public final SourcePosition getSourcePosition() {
        return this.sourcePosition;
    }

    public final String getMessage() {
        return this.message;
    }

    public final Severity getDefaultSeverity() {
        return this.defaultSeverity;
    }

    public final String toString() {
        return this.sourcePosition.toString() + ": " + this.getMessage();
    }

    public final boolean equals(Object that) {
        return this == that || that instanceof Alert && this.equals((Alert)that);
    }

    private boolean equals(Alert that) {
        return this.getSourcePosition().equals((Object)that.getSourcePosition()) && this.getMessage().equals(that.getMessage()) && this.getDefaultSeverity().equals((Object)that.getDefaultSeverity());
    }

    public final int hashCode() {
        return Objects.hashCode(new Object[]{this.getSourcePosition(), this.getMessage(), this.getDefaultSeverity()});
    }

    public static enum Severity {
        INFO,
        WARNING,
        ERROR;

    }
}

