/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.alerts.common.StaticValueExpectedError;
import com.google.gxp.compiler.base.AbstractNode;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.schema.Schema;
import java.util.Collections;
import java.util.List;

public abstract class Expression
extends AbstractNode {
    private final Schema schema;

    protected Expression(SourcePosition sourcePosition, String displayName, Schema schema) {
        super(sourcePosition, displayName);
        this.schema = schema;
    }

    protected Expression(Node fromNode, Schema schema) {
        super(fromNode);
        this.schema = schema;
    }

    protected Expression(Expression fromExpression) {
        super(fromExpression);
        this.schema = fromExpression.getSchema();
    }

    public final Schema getSchema() {
        return this.schema;
    }

    public abstract <T> T acceptVisitor(ExpressionVisitor<T> var1);

    public boolean canEvaluateAs(OutputLanguage outputLanguage) {
        return true;
    }

    public boolean alwaysEmpty() {
        return false;
    }

    public boolean alwaysOnlyWhitespace() {
        return this.alwaysEmpty();
    }

    public boolean alwaysEquals(Expression that) {
        return false;
    }

    public boolean alwaysEquals(boolean value) {
        return false;
    }

    public boolean alwaysEqualToXmlEnabled() {
        return false;
    }

    public abstract boolean equals(Object var1);

    protected final boolean equalsExpression(Expression that) {
        return this.equalsAbstractNode(that) && Objects.equal(this.getSchema(), that.getSchema());
    }

    public abstract int hashCode();

    protected final int expressionHashCode() {
        return Objects.hashCode(this.abstractNodeHashCode(), this.getSchema());
    }

    public String getStaticString(AlertSink alertSink, String fallback) {
        alertSink.add(new StaticValueExpectedError(this));
        return fallback;
    }

    public boolean hasStaticString() {
        return false;
    }

    public List<Expression> separate() {
        return Collections.singletonList(this);
    }
}

