/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.hint.support;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.aot.hint.ResourceHints;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class FilePatternResourceHintsRegistrar {
    private final List<String> classpathLocations;
    private final List<String> filePrefixes;
    private final List<String> fileExtensions;

    @Deprecated(since="6.0.12", forRemoval=true)
    public FilePatternResourceHintsRegistrar(List<String> filePrefixes, List<String> classpathLocations, List<String> fileExtensions) {
        this.classpathLocations = FilePatternResourceHintsRegistrar.validateClasspathLocations(classpathLocations);
        this.filePrefixes = FilePatternResourceHintsRegistrar.validateFilePrefixes(filePrefixes);
        this.fileExtensions = FilePatternResourceHintsRegistrar.validateFileExtensions(fileExtensions);
    }

    @Deprecated(since="6.0.12", forRemoval=true)
    public void registerHints(ResourceHints hints, @Nullable ClassLoader classLoader) {
        ClassLoader classLoaderToUse;
        ClassLoader classLoader2 = classLoaderToUse = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
        if (classLoaderToUse != null) {
            ArrayList<CallSite> includes = new ArrayList<CallSite>();
            for (String location : this.classpathLocations) {
                if (classLoaderToUse.getResource(location) == null) continue;
                for (String filePrefix : this.filePrefixes) {
                    for (String fileExtension : this.fileExtensions) {
                        includes.add((CallSite)((Object)(location + filePrefix + "*" + fileExtension)));
                    }
                }
            }
            if (!includes.isEmpty()) {
                hints.registerPattern(hint -> hint.includes((String[])includes.toArray(String[]::new)));
            }
        }
    }

    public static Builder forClassPathLocations(String ... classpathLocations) {
        return FilePatternResourceHintsRegistrar.forClassPathLocations(Arrays.asList(classpathLocations));
    }

    public static Builder forClassPathLocations(List<String> classpathLocations) {
        return new Builder().withClasspathLocations(classpathLocations);
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> validateClasspathLocations(List<String> classpathLocations) {
        Assert.notEmpty(classpathLocations, "At least one classpath location must be specified");
        ArrayList<String> parsedLocations = new ArrayList<String>();
        for (String string : classpathLocations) {
            void var3_3;
            void var3_8;
            void var3_6;
            if (string.startsWith("classpath:")) {
                String string2 = string.substring("classpath:".length());
            }
            if (var3_6.startsWith("/")) {
                String string3 = var3_6.substring(1);
            }
            if (!var3_8.isEmpty() && !var3_8.endsWith("/")) {
                String string4 = (String)var3_8 + "/";
            }
            parsedLocations.add((String)var3_3);
        }
        return parsedLocations;
    }

    private static List<String> validateFilePrefixes(List<String> filePrefixes) {
        for (String filePrefix : filePrefixes) {
            if (!filePrefix.contains("*")) continue;
            throw new IllegalArgumentException("File prefix '" + filePrefix + "' cannot contain '*'");
        }
        return filePrefixes;
    }

    private static List<String> validateFileExtensions(List<String> fileExtensions) {
        for (String fileExtension : fileExtensions) {
            if (fileExtension.startsWith(".")) continue;
            throw new IllegalArgumentException("Extension '" + fileExtension + "' must start with '.'");
        }
        return fileExtensions;
    }

    public static final class Builder {
        private final List<String> classpathLocations = new ArrayList<String>();
        private final List<String> filePrefixes = new ArrayList<String>();
        private final List<String> fileExtensions = new ArrayList<String>();

        private Builder() {
        }

        public Builder withClasspathLocations(String ... classpathLocations) {
            return this.withClasspathLocations(Arrays.asList(classpathLocations));
        }

        public Builder withClasspathLocations(List<String> classpathLocations) {
            this.classpathLocations.addAll(FilePatternResourceHintsRegistrar.validateClasspathLocations(classpathLocations));
            return this;
        }

        public Builder withFilePrefixes(String ... filePrefixes) {
            return this.withFilePrefixes(Arrays.asList(filePrefixes));
        }

        public Builder withFilePrefixes(List<String> filePrefixes) {
            this.filePrefixes.addAll(FilePatternResourceHintsRegistrar.validateFilePrefixes(filePrefixes));
            return this;
        }

        public Builder withFileExtensions(String ... fileExtensions) {
            return this.withFileExtensions(Arrays.asList(fileExtensions));
        }

        public Builder withFileExtensions(List<String> fileExtensions) {
            this.fileExtensions.addAll(FilePatternResourceHintsRegistrar.validateFileExtensions(fileExtensions));
            return this;
        }

        private FilePatternResourceHintsRegistrar build() {
            return new FilePatternResourceHintsRegistrar(this.filePrefixes, this.classpathLocations, this.fileExtensions);
        }

        public void registerHints(ResourceHints hints, @Nullable ClassLoader classLoader) {
            this.build().registerHints(hints, classLoader);
        }
    }
}

