/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.test.impl.logger;

import org.flowable.common.engine.impl.agenda.AgendaOperationExecutionListener;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.test.impl.logger.DebugInfoOperationExecuted;
import org.flowable.engine.test.impl.logger.ProcessExecutionLogger;

public class LoggingAgendaOperationExecutionListener
implements AgendaOperationExecutionListener {
    protected final ProcessExecutionLogger processExecutionLogger;

    public LoggingAgendaOperationExecutionListener(ProcessExecutionLogger processExecutionLogger) {
        this.processExecutionLogger = processExecutionLogger;
    }

    public void beforeAll(CommandContext commandContext) {
    }

    public void beforeExecute(CommandContext commandContext, Runnable runnable) {
        DebugInfoOperationExecuted debugInfo = null;
        if (runnable instanceof AbstractOperation) {
            AbstractOperation operation = (AbstractOperation)runnable;
            debugInfo = new DebugInfoOperationExecuted(operation);
            debugInfo.setPreExecutionTime(System.currentTimeMillis());
            this.processExecutionLogger.addDebugInfo(debugInfo, true);
            commandContext.addAttribute(this.getDebugInfoKey(runnable), (Object)debugInfo);
        }
    }

    public void afterExecute(CommandContext commandContext, Runnable runnable) {
        if (runnable instanceof AbstractOperation) {
            String debugInfoKey = this.getDebugInfoKey(runnable);
            Object attribute = commandContext.getAttribute(debugInfoKey);
            commandContext.removeAttribute(debugInfoKey);
            if (attribute instanceof DebugInfoOperationExecuted) {
                DebugInfoOperationExecuted debugInfo = (DebugInfoOperationExecuted)attribute;
                debugInfo.setPostExecutionTime(System.currentTimeMillis());
            }
        }
    }

    public void afterExecuteException(CommandContext commandContext, Runnable runnable, Throwable error) {
        this.afterExecute(commandContext, runnable);
    }

    public void afterAll(CommandContext commandContext) {
    }

    protected String getDebugInfoKey(Runnable runnable) {
        return "debug-info-" + runnable.getClass().getName() + "@" + Integer.toHexString(runnable.hashCode());
    }
}

