/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.validation.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apereo.cas.client.util.CommonUtils;
import org.apereo.cas.client.validation.TicketValidationException;
import org.apereo.cas.client.validation.json.TicketValidationJsonResponse;

final class JsonValidationResponseParser {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonValidationResponseParser() {
        this.objectMapper.findAndRegisterModules();
    }

    public TicketValidationJsonResponse parse(String response) throws TicketValidationException, IOException {
        if (CommonUtils.isBlank(response)) {
            throw new TicketValidationException("Invalid JSON response; The response is empty");
        }
        TicketValidationJsonResponse json = (TicketValidationJsonResponse)this.objectMapper.readValue(response, TicketValidationJsonResponse.class);
        TicketValidationJsonResponse.CasServiceResponseAuthentication serviceResponse = json.serviceResponse();
        if (serviceResponse.authenticationFailure() != null && serviceResponse.authenticationSuccess() != null) {
            throw new TicketValidationException("Invalid JSON response; It indicates both a success and a failure event, which is indicative of a server error. The actual response is " + response);
        }
        if (serviceResponse.authenticationFailure() != null) {
            String error = json.serviceResponse().authenticationFailure().getCode() + " - " + serviceResponse.authenticationFailure().getDescription();
            throw new TicketValidationException(error);
        }
        String principal = json.serviceResponse().authenticationSuccess().getUser();
        if (CommonUtils.isEmpty(principal)) {
            throw new TicketValidationException("No principal was found in the response from the CAS server.");
        }
        return json;
    }
}

