/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad;

import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsResponse;
import net.tirasa.adsddl.ntsd.controls.SDFlagsControl;
import net.tirasa.connid.bundles.ad.ADConfiguration;
import net.tirasa.connid.bundles.ad.schema.ADSchema;
import net.tirasa.connid.bundles.ad.util.TrustAllSocketFactory;
import net.tirasa.connid.bundles.ldap.LdapConfiguration;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import org.identityconnectors.common.Pair;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.InvalidCredentialException;

public class ADConnection
extends LdapConnection {
    private static final Log LOG = Log.getLog(ADConnection.class);
    private static final String LDAP_CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String LDAP_CTX_SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    private static final String LDAP_BINARY_ATTRIBUTE = "java.naming.ldap.attributes.binary";
    private LdapContext syncCtx = null;

    public ADConnection(LdapConfiguration config) {
        super(config);
        this.schema = new ADSchema(this);
    }

    public LdapContext getSyncContext(Control[] control) {
        return this.cloneContext(control);
    }

    public void close() {
        try {
            super.close();
            ADConnection.quietClose((Pair)new Pair((Object)this.syncCtx, (Object)this.tlsCtx));
        }
        finally {
            this.syncCtx = null;
        }
    }

    private LdapContext cloneContext(Control[] controls) {
        try {
            return this.getInitialContext().newInstance(controls);
        }
        catch (NamingException e) {
            LOG.error((Throwable)e, "Context initialization failed", new Object[0]);
            return null;
        }
    }

    public LdapContext getInitialContext() {
        if (this.initCtx != null) {
            return this.initCtx;
        }
        Pair connectPair = this.connect(this.config.getPrincipal(), this.config.getCredentials());
        this.initCtx = (LdapContext)connectPair.first;
        this.tlsCtx = (StartTlsResponse)connectPair.second;
        try {
            this.initCtx.setRequestControls(new Control[]{new SDFlagsControl(4)});
        }
        catch (NamingException e) {
            LOG.error((Throwable)e, "Error initializing request controls", new Object[0]);
        }
        return this.initCtx;
    }

    protected Pair<LdapConnection.AuthenticationResult, Pair<LdapContext, StartTlsResponse>> createContext(String principal, GuardedString credentials) {
        ArrayList<Pair> result = new ArrayList<Pair>(1);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", LDAP_CTX_FACTORY);
        env.put("java.naming.provider.url", this.getLdapUrls());
        env.put("java.naming.referral", "follow");
        env.put("com.sun.jndi.ldap.connect.timeout", Long.toString(this.config.getConnectTimeout()));
        env.put("com.sun.jndi.ldap.read.timeout", Long.toString(this.config.getReadTimeout()));
        if (this.config.isSsl()) {
            env.put("java.naming.security.protocol", "ssl");
            if (((ADConfiguration)this.config).isTrustAllCerts()) {
                env.put(LDAP_CTX_SOCKET_FACTORY, TrustAllSocketFactory.class.getName());
            }
        }
        env.put(LDAP_BINARY_ATTRIBUTE, "ntSecurityDescriptor objectGUID objectSID");
        String authentication = StringUtil.isNotBlank((String)principal) ? "simple" : "none";
        env.put("java.naming.security.authentication", authentication);
        if (LOG.isOk()) {
            LOG.ok("Initial context environment: {0}", new Object[]{env});
        }
        if (StringUtil.isNotBlank((String)principal)) {
            env.put("java.naming.security.principal", principal);
            if (credentials != null) {
                credentials.access(clearChars -> {
                    if (clearChars == null || clearChars.length == 0) {
                        throw new InvalidCredentialException("Password is blank");
                    }
                    env.put("java.naming.security.credentials", new String(clearChars));
                });
            }
        }
        result.add(this.createContext(env));
        return (Pair)result.get(0);
    }
}

