/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Deadline;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=120L)
public class DeadlineTest {
    private static Time monoTime(long monotonicTime) {
        return new MockTime(0L, 0L, monotonicTime);
    }

    @Test
    public void testOneMillisecondDeadline() {
        Assertions.assertEquals((long)TimeUnit.MILLISECONDS.toNanos(1L), (long)Deadline.fromDelay((Time)DeadlineTest.monoTime(0L), (long)1L, (TimeUnit)TimeUnit.MILLISECONDS).nanoseconds());
    }

    @Test
    public void testOneMillisecondDeadlineWithBase() {
        long nowNs = 123456789L;
        Assertions.assertEquals((long)(123456789L + TimeUnit.MILLISECONDS.toNanos(1L)), (long)Deadline.fromDelay((Time)DeadlineTest.monoTime(123456789L), (long)1L, (TimeUnit)TimeUnit.MILLISECONDS).nanoseconds());
    }

    @Test
    public void testNegativeDelayFails() {
        Assertions.assertEquals((Object)"Negative delays are not allowed.", (Object)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> Deadline.fromDelay((Time)DeadlineTest.monoTime(123456789L), (long)-1L, (TimeUnit)TimeUnit.MILLISECONDS))).getMessage());
    }

    @Test
    public void testMaximumDelay() {
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)Deadline.fromDelay((Time)DeadlineTest.monoTime(123L), (long)Long.MAX_VALUE, (TimeUnit)TimeUnit.HOURS).nanoseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)Deadline.fromDelay((Time)DeadlineTest.monoTime(0L), (long)0x3FFFFFFFFFFFFFFFL, (TimeUnit)TimeUnit.MILLISECONDS).nanoseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)Deadline.fromDelay((Time)DeadlineTest.monoTime(Long.MAX_VALUE), (long)Long.MAX_VALUE, (TimeUnit)TimeUnit.NANOSECONDS).nanoseconds());
    }
}

