/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.client.ui.commons.wizards.any.EntityWrapper;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.PushTaskTO;

public class PushTaskWrapper
extends EntityWrapper<PushTaskTO> {
    private static final long serialVersionUID = 8058288034211558377L;
    private Map<String, List<SearchClause>> filterClauses;

    public PushTaskWrapper(PushTaskTO pushTaskTO) {
        super((EntityTO)pushTaskTO);
        this.getFilterClauses();
    }

    public final Map<String, List<SearchClause>> getFilterClauses() {
        if (this.filterClauses == null) {
            this.filterClauses = SearchUtils.getSearchClauses(((PushTaskTO)this.getInnerObject()).getFilters());
        }
        return this.filterClauses;
    }

    public void setFilterClauses(Map<String, List<SearchClause>> aDynClauses) {
        this.filterClauses = aDynClauses;
    }

    public Map<String, String> getFilters() {
        HashMap<String, String> filters = new HashMap<String, String>();
        for (Map.Entry<String, List<SearchClause>> entry : this.getFilterClauses().entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            filters.put(entry.getKey(), SearchUtils.buildFIQL(entry.getValue(), switch (entry.getKey()) {
                case "USER" -> SyncopeClient.getUserSearchConditionBuilder();
                case "GROUP" -> SyncopeClient.getGroupSearchConditionBuilder();
                default -> SyncopeClient.getAnyObjectSearchConditionBuilder((String)entry.getKey());
            }));
        }
        return filters;
    }

    public PushTaskTO fillFilterConditions() {
        ((PushTaskTO)this.getInnerObject()).getFilters().clear();
        ((PushTaskTO)this.getInnerObject()).getFilters().putAll(this.getFilters());
        return (PushTaskTO)this.getInnerObject();
    }
}

