/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.wechat;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.Token;
import java.util.Arrays;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.core.profile.converter.GenderConverter;
import org.pac4j.oauth.client.WechatClient;
import org.pac4j.oauth.config.OAuthConfiguration;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.definition.OAuthProfileDefinition;
import org.pac4j.oauth.profile.wechat.WechatProfile;
import org.pac4j.scribe.model.WechatToken;

public class WechatProfileDefinition
extends OAuthProfileDefinition {
    public static final String OPENID = "openid";
    public static final String NICKNAME = "nickname";
    public static final String SEX = "sex";
    public static final String PROVINCE = "province";
    public static final String CITY = "city";
    public static final String COUNTRY = "country";
    public static final String HEADIMGURL = "headimgurl";
    public static final String PRIVILEGE = "privilege ";
    public static final String UNIONID = "unionid";

    public WechatProfileDefinition() {
        Arrays.stream(new String[]{OPENID, NICKNAME, PROVINCE, CITY, COUNTRY, PRIVILEGE, UNIONID}).forEach(a -> this.primary((String)a, Converters.STRING));
        this.primary(SEX, (AttributeConverter)new GenderConverter("1", "2"));
        this.primary(HEADIMGURL, Converters.URL);
    }

    @Override
    public String getProfileUrl(Token accessToken, OAuthConfiguration configuration) {
        if (accessToken instanceof WechatToken) {
            WechatToken token = (WechatToken)accessToken;
            String profileUrl = WechatClient.WechatScope.SNSAPI_BASE.toString().equalsIgnoreCase(token.getScope()) ? "https://api.weixin.qq.com/sns/auth?openid=" + token.getOpenid() : "https://api.weixin.qq.com/sns/userinfo?openid=" + token.getOpenid();
            return profileUrl;
        }
        throw new OAuthException("Token in getProfileUrl is not an WechatToken");
    }

    @Override
    public WechatProfile extractUserProfile(String body) {
        WechatProfile profile = new WechatProfile();
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json != null) {
            Integer errcode = (Integer)JsonHelper.getElement(json, "errcode");
            if (errcode != null && errcode > 0) {
                Object errmsg = JsonHelper.getElement(json, "errmsg");
                throw new OAuthException((String)(errmsg != null ? errmsg.toString() : "error code " + errcode));
            }
            for (String attribute : this.getPrimaryAttributes()) {
                this.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
            }
        } else {
            this.raiseProfileExtractionJsonError(body);
        }
        return profile;
    }
}

