/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.lang;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ByteSequence
implements Serializable {
    private byte[] buff;
    private int offset;
    private int length;

    public ByteSequence(byte[] buff) {
        this.set(buff, 0, buff.length);
    }

    public ByteSequence(byte[] buff, int offset, int length) {
        this.set(buff, offset, length);
    }

    public void set(byte[] buff, int offset, int length) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("ByteSequence index out of range: " + offset);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("ByteSequence index out of range: " + length);
        }
        if (offset > buff.length - length) {
            throw new StringIndexOutOfBoundsException("ByteSequence index out of range: " + (offset + length));
        }
        this.buff = buff;
        this.offset = offset;
        this.length = length;
    }

    public byte byteAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException(index + " is not in range [0, " + this.length + ")");
        }
        return this.buff[this.offset + index];
    }

    public byte[] buffer() {
        return this.buff;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public ByteSequence slice(int offset) {
        return new ByteSequence(this.buff, this.offset + offset, this.length - offset);
    }

    public ByteSequence slice(int offset, int length) {
        return new ByteSequence(this.buff, this.offset + offset, length);
    }

    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.buff, this.offset, this.length);
    }

    public byte[] toByteArray(boolean clone) {
        if (!clone && this.offset == 0 && this.buff.length == this.length) {
            return this.buff;
        }
        byte[] array = new byte[this.length];
        System.arraycopy(this.buff, this.offset, array, 0, this.length);
        return array;
    }

    public ByteArrayInputStream asInputStream() {
        return new ByteArrayInputStream(this.buffer(), this.offset(), this.length());
    }

    public String toString(Charset charset) {
        return new String(this.buff, this.offset, this.length, charset);
    }

    public String toString(String charset) throws UnsupportedEncodingException {
        return new String(this.buff, this.offset, this.length, charset);
    }

    public String toString() {
        return new String(this.buff, this.offset, this.length);
    }

    public ByteSequence copy() {
        return new ByteSequence(this.toByteArray(true), 0, this.length);
    }
}

