/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.tabcontrol;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import javax.swing.Icon;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.view.ui.slides.SlideController;
import org.netbeans.core.windows.view.ui.tabcontrol.AbstractTabbedImpl;
import org.netbeans.core.windows.view.ui.tabcontrol.tabbedpane.CloseableTabComponent;
import org.netbeans.core.windows.view.ui.tabcontrol.tabbedpane.NBTabbedPane;
import org.netbeans.core.windows.view.ui.tabcontrol.tabbedpane.NBTabbedPaneController;
import org.netbeans.swing.tabcontrol.ComponentConverter;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.customtabs.Tabbed;
import org.netbeans.swing.tabcontrol.customtabs.TabbedType;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.openide.windows.TopComponent;

public class JTabbedPaneAdapter
extends NBTabbedPane
implements Tabbed.Accessor,
SlideController {
    private NBTabbedPaneController controller;
    private final AbstractTabbedImpl tabbedImpl = new AbstractTabbedImpl(){

        public int getTabCount() {
            return JTabbedPaneAdapter.this.getTabCount();
        }

        public int indexOf(Component component) {
            return JTabbedPaneAdapter.this.indexOf(component);
        }

        public void setTitleAt(int n, String string) {
            CloseableTabComponent closeableTabComponent = (CloseableTabComponent)JTabbedPaneAdapter.this.getTabComponentAt(n);
            closeableTabComponent.setTitle(string);
            this.getTabModel().setText(n, string);
        }

        public void setIconAt(int n, Icon icon) {
            CloseableTabComponent closeableTabComponent = (CloseableTabComponent)JTabbedPaneAdapter.this.getTabComponentAt(n);
            closeableTabComponent.setIcon(icon);
        }

        public void setToolTipTextAt(int n, String string) {
            CloseableTabComponent closeableTabComponent = (CloseableTabComponent)JTabbedPaneAdapter.this.getTabComponentAt(n);
            closeableTabComponent.setTooltip(string);
        }

        public void addActionListener(ActionListener actionListener) {
            JTabbedPaneAdapter.this.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            JTabbedPaneAdapter.this.removeActionListener(actionListener);
        }

        public void setActive(boolean bl) {
            JTabbedPaneAdapter.this.setActive(bl);
        }

        public int tabForCoordinate(Point point) {
            return JTabbedPaneAdapter.this.tabForCoordinate(point);
        }

        public Image createImageOfTab(int n) {
            return JTabbedPaneAdapter.this.createImageOfTab(n);
        }

        public Component getComponent() {
            return JTabbedPaneAdapter.this;
        }

        public Rectangle getTabBounds(int n) {
            return JTabbedPaneAdapter.this.getBoundsAt(n);
        }

        public Rectangle getTabsArea() {
            return JTabbedPaneAdapter.this.getBounds();
        }

        public boolean isTransparent() {
            return false;
        }

        public void setTransparent(boolean bl) {
        }

        @Override
        protected TabDataModel getTabModel() {
            return JTabbedPaneAdapter.this.getDataModel();
        }

        @Override
        protected SingleSelectionModel getSelectionModel() {
            return JTabbedPaneAdapter.this.getModel();
        }

        @Override
        protected void requestAttention(int n) {
            JTabbedPaneAdapter.this.requestAttention(n);
        }

        @Override
        protected void cancelRequestAttention(int n) {
            JTabbedPaneAdapter.this.cancelRequestAttention(n);
        }

        @Override
        protected void setAttentionHighlight(int n, boolean bl) {
            JTabbedPaneAdapter.this.setAttentionHighlight(n, bl);
        }

        @Override
        protected int dropIndexOfPoint(Point point) {
            return JTabbedPaneAdapter.this.dropIndexOfPoint(point);
        }

        @Override
        protected ComponentConverter getComponentConverter() {
            return JTabbedPaneAdapter.this.getComponentConverter();
        }

        @Override
        protected Shape getDropIndication(TopComponent topComponent, Point point) {
            return JTabbedPaneAdapter.this.getDropIndication(topComponent, point);
        }
    };

    public JTabbedPaneAdapter(TabbedType tabbedType, WinsysInfoForTabbedContainer winsysInfoForTabbedContainer) {
        super(null, tabbedType, winsysInfoForTabbedContainer);
        this.controller = new NBTabbedPaneController(this);
        this.controller.attachModelAndSelectionListeners();
        this.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = JTabbedPaneAdapter.this.getModel().getSelectedIndex();
                if (n != -1) {
                    JTabbedPaneAdapter.this.tabbedImpl.fireStateChanged();
                }
            }
        });
    }

    public Shape getDropIndication(Object object, Point point) {
        int n = this.dropIndexOfPoint(point);
        Rectangle rectangle = this.getSelectedComponent().getBounds();
        Area area = new Area(rectangle);
        Rectangle rectangle2 = null;
        Rectangle rectangle3 = null;
        if (n > 0 && n < this.getTabCount()) {
            rectangle2 = this.getBoundsAt(n - 1);
        }
        if (n < this.getTabCount()) {
            rectangle3 = this.getBoundsAt(n);
        }
        if (n >= this.getTabCount()) {
            rectangle2 = this.getBoundsAt(this.getTabCount() - 1);
            rectangle3 = null;
        }
        Rectangle rectangle4 = this.joinTabAreas(rectangle2, rectangle3);
        Area area2 = new Area(rectangle4);
        area.add(area2);
        return area;
    }

    private Rectangle joinTabAreas(Rectangle rectangle, Rectangle rectangle2) {
        assert (null != rectangle || null != rectangle2);
        Rectangle rectangle3 = new Rectangle();
        switch (this.getTabPlacement()) {
            case 1: 
            case 3: {
                if (null != rectangle && null != rectangle2 && rectangle.y != rectangle2.y) {
                    rectangle = null;
                }
                if (null == rectangle) {
                    rectangle3.height = rectangle2.height;
                    rectangle3.y = rectangle2.y;
                    rectangle3.x = rectangle2.x;
                    rectangle3.width = rectangle2.width / 2;
                    break;
                }
                if (null == rectangle2) {
                    rectangle3.height = rectangle.height;
                    rectangle3.y = rectangle.y;
                    rectangle3.x = rectangle.x + rectangle.width / 2;
                    rectangle3.width = rectangle.width / 2;
                    break;
                }
                rectangle3.height = rectangle.height;
                rectangle3.y = rectangle.y;
                rectangle3.x = rectangle.x + rectangle.width / 2;
                rectangle3.width = rectangle.width / 2 + rectangle2.width / 2;
                break;
            }
            case 2: 
            case 4: {
                if (null != rectangle && null != rectangle2 && rectangle.x != rectangle2.x) {
                    rectangle = null;
                }
                if (null == rectangle) {
                    rectangle3.width = rectangle2.width;
                    rectangle3.y = rectangle2.y;
                    rectangle3.x = rectangle2.x;
                    rectangle3.height = rectangle2.height / 2;
                    break;
                }
                if (null == rectangle2) {
                    rectangle3.width = rectangle.width;
                    rectangle3.x = rectangle.x;
                    rectangle3.y = rectangle.y + rectangle.height / 2;
                    rectangle3.height = rectangle.height / 2;
                    break;
                }
                rectangle3.width = rectangle.width;
                rectangle3.x = rectangle.x;
                rectangle3.y = rectangle.y + rectangle.height / 2;
                rectangle3.height = rectangle.height / 2 + rectangle2.height / 2;
            }
        }
        return rectangle3;
    }

    public Tabbed getTabbed() {
        return this.tabbedImpl;
    }

    @Override
    public void userToggledAutoHide(int n, boolean bl) {
        this.postActionEvent(new TabActionEvent((Object)this, "enableAutoHide", n));
    }

    @Override
    public void userToggledTransparency(int n) {
        this.postActionEvent(new TabActionEvent((Object)this, "toggleTransparency", n));
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }
}

