/*
**  ctype.h             ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**                      P.O. BOX 79
**                      Kingston, MA. 02364
**                      (508) 746 - 7341 Voice
**                      (508) 746 - 4678 FAX
**                      e-mail uunet!microway!mark
**                             mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _CTYPE_H
#define _CTYPE_H

#define _UPPER          0x01
#define _LOWER          0x02
#define _DIGIT          0x04
#define _SPACE          0x08
#define _PUNCT          0x10
#define _CONTROL        0x20
#define _HEXDIGIT       0x40
#define _BEL            0x80
#define _EXALPHA        0x100
#define _EXSPACE        0x200

extern short *_Ctype;
extern short *_ToLower;
extern short *_ToUpper;

#ifndef _WCHAR_T
#define _WCHAR_T
typedef unsigned short wchar_t;
#endif  /* _WCHAR_T */

#if defined(__STDC__) || defined(__NDPX__)
#ifdef __NDPX__         /* C++ */
   extern "C" {
#endif

int       isalnum(int);
int       isalpha(int);
int       iscntrl(int);
int       isdigit(int);
int       isgraph(int);
int       islower(int);
int       isprint(int);
int       ispunct(int);
int       isspace(int);
int       isupper(int);
int       isxdigit(int);
int       tolower(int);
int       toupper(int);

#ifdef __NDPX__         /* C++ */
   }
#endif  /* __NDPX__ */
#else                           /* K&R */

int       isalnum();
int       isalpha();
int       iscntrl();
int       isdigit();
int       isgraph();
int       islower();
int       isprint();
int       ispunct();
int       isspace();
int       isupper();
int       isxdigit();
int       tolower();
int       toupper();

#endif  /* __STDC__ || __NDPX__ */

#define   isalnum(_Ch) (((_Ctype)[(int)(_Ch)])&(_UPPER|_LOWER|_DIGIT|_EXALPHA))
#define   isalpha(_Ch) (((_Ctype)[(int)(_Ch)])&(_UPPER|_LOWER|_EXALPHA))
#define   iscntrl(_Ch) (((_Ctype)[(int)(_Ch)])&(_CONTROL|_BEL))
#define   isdigit(_Ch) (((_Ctype)[(int)(_Ch)])&(_DIGIT))
#define   isgraph(_Ch) \
        (((_Ctype)[(int)(_Ch)])&(_UPPER|_LOWER|_DIGIT|_PUNCT|_EXALPHA))
#define   isprint(_Ch) \
        (((_Ctype)[(int)(_Ch)])&(_SPACE|_UPPER|_LOWER|_DIGIT|_PUNCT|_EXALPHA))
#define   islower(_Ch) (((_Ctype)[(int)(_Ch)])&(_LOWER))
#define   ispunct(_Ch) (((_Ctype)[(int)(_Ch)])&(_PUNCT))
#define   isspace(_Ch) (((_Ctype)[(int)(_Ch)])&(_SPACE|_CONTROL|_EXSPACE))
#define   isupper(_Ch) (((_Ctype)[(int)(_Ch)])&(_UPPER))
#define   isxdigit(_Ch) (((_Ctype)[(int)(_Ch)])&(_DIGIT|_HEXDIGIT))
#define   tolower(_Ch) ((_ToLower)[(int)(_Ch)])
#define   toupper(_Ch) ((_ToUpper)[(int)(_Ch)])

#endif  /* _CTYPE_H */

