/*  
**  cxstdio.h		C++ Runtime 
**
**  Copyright (C)	Microway, Inc. 1987 - 1994.
**			P.O. BOX 79
**			Kingston, MA. 02364
**			(508) 746 - 7341 Voice
**			(508) 746 - 4678 FAX
**			e-mail tech@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/
/* Streams like interface to stdio */

#ifndef __CXSTDIO_H
# define __CXSTDIO_H

# include <stdio.h>

#define cstdout (*stdout)
#define cstdin	(*stdin)
#define cstderr (*stderr)

inline FILE &operator<<(FILE &t,FILE & (*m)(FILE&))    { return m(t); }
FILE &endl(FILE &);
FILE &flush(FILE &);

FILE &operator<<(FILE &t,const char *s) { fprintf( &t, "%s", s); return t;}
/* FILE &operator<<(FILE &t,long double v) { fprintf( &t, "%g", v); return t;}*/
FILE &operator<<(FILE &t,double v) { fprintf( &t, "%g", v); return t;}
FILE &operator<<(FILE &t,float v) { fprintf( &t, "%g", v); return t;}
FILE &operator<<(FILE &t,long v) { fprintf( &t, "%d", v); return t;}
FILE &operator<<(FILE &t,int v) { fprintf( &t, "%d", v); return t;}
FILE &operator<<(FILE &t,short v) { fprintf( &t, "%d", v); return t;}
FILE &operator<<(FILE &t,char v) { fprintf( &t, "%c", v); return t;}
FILE &operator<<(FILE &t,unsigned long v) { fprintf( &t, "%u", v); return t;}
FILE &operator<<(FILE &t,unsigned int v) { fprintf( &t, "%u", v); return t;}
FILE &operator<<(FILE &t,unsigned short v) { fprintf( &t, "%u", v); return t;}
FILE &operator<<(FILE &t,unsigned char v) { fprintf( &t, "%c", v); return t;}

FILE &operator>>(FILE &t,const char *s) { fscanf( &t, "%s", s); return t;}
/* FILE &operator>>(FILE &t,long double v) { double d; fscanf( &t, "%g", &d); v=d; return t;} */
FILE &operator>>(FILE &t,double v) { fscanf( &t, "%lg", &v); return t;}
FILE &operator>>(FILE &t,float v) { fscanf( &t, "%g", &v); return t;}
FILE &operator>>(FILE &t,long v) { fscanf( &t, "%ld", &v); return t;}
FILE &operator>>(FILE &t,int v) { fscanf( &t, "%d", &v); return t;}
FILE &operator>>(FILE &t,short v) { fscanf( &t, "%hd", &v); return t;}
FILE &operator>>(FILE &t,char v) { fscanf( &t, "%c", &v); return t;}
FILE &operator>>(FILE &t,unsigned long v) { fscanf( &t, "%lu", &v); return t;}
FILE &operator>>(FILE &t,unsigned int v) { fscanf( &t, "%u", &v); return t;}
FILE &operator>>(FILE &t,unsigned short v) { fscanf( &t, "%hu", &v); return t;}
FILE &operator>>(FILE &t,unsigned char v) { fscanf( &t, "%c", &v); return t;}

#endif
