/*
**  float.h             ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**                      P.O. BOX 79
**                      Kingston, MA. 02364
**                      (508) 746 - 7341 Voice
**                      (508) 746 - 7341 FAX
**                      e-mail uunet!microway!mark
**                             mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _FLOAT_H
#define _FLOAT_H

/* values for macros */
#define FLT_RADIX               2
#define FLT_ROUNDS              1

#define FLT_DIG                 7
#define FLT_MANT_DIG            24
#define FLT_MAX_10_EXP          38
#define FLT_MAX_EXP             128
#define FLT_MIN_10_EXP          -37
#define FLT_MIN_EXP             -125
#define FLT_EPSILON             _EpsFVAL._U._Fval
#define FLT_MAX                 _MaxFVAL._U._Fval
#define FLT_MIN                 _MinFVAL._U._Fval

#define DBL_DIG                 15
#define DBL_MANT_DIG            53
#define DBL_MAX_10_EXP          308
#define DBL_MAX_EXP             1024
#define DBL_MIN_10_EXP          -307
#define DBL_MIN_EXP             -1021
#define DBL_EPSILON             _EpsDVAL._U._Dval
#define DBL_MAX                 _MaxDVAL._U._Dval
#define DBL_MIN                 _MinDVAL._U._Dval

#define LDBL_DIG                15
#define LDBL_MANT_DIG           53
#define LDBL_MAX_10_EXP         308
#define LDBL_MAX_EXP            1024
#define LDBL_MIN_10_EXP         -307
#define LDBL_MIN_EXP            -1021
#define LDBL_EPSILON            _EpsDVAL._U._Dval
#define LDBL_MAX                _MaxDVAL._U._Dval
#define LDBL_MIN                _MinDVAL._U._Dval

/* represent floating point values for MAX, MIN, and EPS as doubles
   constructed by assigning correct bit patterns in int part of union
*/
struct _DVAL {
    union {
        unsigned long _ULval[2];
	double _Dval;
    }_U;
};

struct _FVAL {
    union {
        unsigned long _ULval;
        float _Fval;
    }_U;
};

extern struct _DVAL _MaxDVAL, _MinDVAL, _EpsDVAL;
extern struct _FVAL _MaxFVAL, _MinFVAL, _EpsFVAL;

#endif  /* _FLOAT_H */
