/*
**  signal.h            ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**                      P.O. BOX 79
**                      Kingston, MA. 02364
**                      (508) 746 - 7341 Voice
**                      (508) 746 - 4678 FAX
**                      e-mail uunet!microway!mark
**                             mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _SIGNAL_H
#define _SIGNAL_H

typedef int sig_atomic_t;

#define SIGINT          2
#define SIGILL          4
#define SIGABRT         6
#define SIGFPE          8
#define SIGSEGV         11
#define SIGTERM         15

/* standard bsd signals in addition to these */
#define SIGHUP          1
#define SIGQUIT         3
#define SIGTRAP         5
#define SIGIOT          SIGABRT
#define SIGEMT          7
#define SIGKILL         9
#define SIGBUS          10
#define SIGSYS          12
#define SIGPIPE         13
#define SIGALRM         14
#define SIGURG          17
#define SIGSTOP         18
#define SIGTSTP         19
#define SIGCONT         20
#define SIGCHLD         21
#define SIGCLD          SIGCHLD
#define SIGTTIN         22
#define SIGTTOU         23
#define SIGIO           24
#define SIGXCPU         25
#define SIGXTIM         26
#define SIGXFSZ         27
#define SIGVTALRM       28
#define SIGPROF         29
#define SIGWINCH        30
#define SIGUSR1         31
#define SIGUSR2         32
#define _SIGMAX         SIGUSR2

#if defined(__STDC__) || defined(__NDPX__)
#ifdef __i860

struct process_context {
        long    intreg[32];
        float   fltreg[32];
        double  T, KI, KR;
        long    MERGE[2];
        double  l1, l2, l3;     /* load pipeline */
        double  a1, a2, a3;     /* adder pipeline */
        double  m1, m2, m3;     /* multiplier pipeline */
        long    i1[2];          /* vector-integer result */
        long    fsr1, fsr2;     /* pipe result status */
        long    fsr, psr, fir, dirbase, db, epsr;
        long    afir;           /* addr of faulting inst: fir or fir+4 */
};
#define _SIGNAL_ARG     int, struct process_context *, struct process_context *
#else
#define _SIGNAL_ARG     _function
#endif

typedef void (*_function)(int);

#ifdef __NDPX__                 /* C++ */
   extern "C" {
#endif

_function signal(int sig, _SIGNAL_ARG);
int       raise(int sig_);

#ifdef __i860
int      _sig_return(struct process_context *);
#endif  /* __i860 */

#ifdef __NDPX__                 /* C++ */
   }
#endif

#define SIG_DFL         ((_function)0)
#define SIG_IGN         ((_function)1)
#define SIG_ERR         ((_function)-1)
#else                           /* K&R */
#ifdef __i860
int _sig_return();
#endif  /* __i860 */
void    (*signal())();
int       raise();
#define SIG_DFL         ((void (*)()) 0)
#define SIG_IGN         ((void (*)()) 1)
#define SIG_ERR         ((void (*)()) (-1))

#endif  /* __STDC__ || __NDPX__ */
#endif  /* _SIGNAL_H */

