/*  
**  sstream.h		C++ Runtime
**
**  Copyright (C)	Microway, Inc. 1987 - 1994.
**			P.O. BOX 79
**			Kingston, MA. 02364
**			(508) 746 - 7341 Voice
**			(508) 746 - 4678 FAX
**			e-mail tech@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef __STRSTREAM_H
# define __STRSTREAM_H
# include <iostream.h>
# ifdef __cppv21
#  define __ios ios::
# else
#  define __ios
# endif
# include <string.h>

#pragma ghs novirtual=(istrstream,ostrstream,strstream)

class strstreambuf : public streambuf {
public:
		strstreambuf();
		strstreambuf(int);
		strstreambuf(void *(*)(long),void (*)(void *));
		strstreambuf(char *p, int n, char *s=0);
		strstreambuf(unsigned char *p, int n, unsigned char *s=0);
    streampos	seekoff(streamoff off, __ios seek_dir m, int);
   virtual	~strstreambuf();

    void	freeze(int f=1)     { _frozen=f; }
    char *	str()		    {freeze(); return( _base );}
    int 	pcount()	    { return( _pptr-_pbase ); }
    streambuf * setbuf(char *,int);

   virtual int	underflow();
   virtual int	overflow(int =EOF);
   virtual int	sync()		    {/* always sunk */return 1;}

protected:
    void	inits(char *,int,char *);
    int 	grow();
    char	_frozen;
    int 	_nextallocmin;
    void *	(*_a)(long);
    void	(*_f)(void *);

};

class istrstream : public istream {
public:
		istrstream(char *str) : buf(str,0,NULL) { init(&buf); }
		istrstream(char *s, int n): buf(s,n,NULL) { init(&buf);}
    strstreambuf *rdbuf()	    { return &buf; }
private:
    strstreambuf buf;
};

class ostrstream : public ostream {
public:
		ostrstream() : buf() { init(&buf); }
		ostrstream(char *s, int n, int mode=ios::out)
				    : buf(s,n,(mode&(ios::ate|ios::app))?s+strlen(s): s)
				    { init(&buf);}
    strstreambuf *rdbuf()	    { return &buf; }
    char *	str()		    { return buf.str(); }
    int 	pcount()	    { return( buf.pcount() );}
private:
    strstreambuf buf;
};

class strstream : public iostream {
public:
		strstream() : buf() { init(&buf); }
		strstream(char *s, int n, int mode=ios::out)
				    : buf(s,n,(mode&(ios::ate|ios::app|ios::in))?s+strlen(s):s)
				    { init(&buf);}
    strstreambuf *rdbuf()	    { return &buf; }
    char *	str()		    { return buf.str(); }
private:
    strstreambuf buf;
};

# undef __ios
#endif
