/*
**  string.h            ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)       Microway, Inc. 1987 - 1994.
**                      P.O. BOX 79
**                      Kingston, MA. 02364
**                      (508) 746 - 7341 Voice
**                      (508) 746 - 4678 FAX
**                      e-mail uunet!microway!mark
**                             mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _STRING_H
#define _STRING_H

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int size_t;
#endif  /* _SIZE_T */

#ifndef NULL
#if defined(__STDC__) || defined(__NDPX__)
#define NULL    ((void *)0L)
#else
#define NULL    ((char *)0L)
#endif
#endif  /* NULL */

#if defined(__STDC__) || defined(__NDPX__)

#ifdef __NDPX__         /* C++ */
   extern "C" {
#endif

void *    memchr(const void *_S, int _C, size_t _N);
int       memcmp(const void *_S1, const void *_S2, size_t _N);
void *    memcpy(void *_S1, const void *_S2, size_t _N);
void *    memmove(void *_S1, const void *_S2, size_t _N);
void *    memset(void *_S, int _C, size_t _N);
char *    strcat(char *_S1, const char *_S2);
char *    strchr(const char *_S, int _C);
int       strcmp(const char *_S1, const char *_S2);
int       strcoll(const char *_S1, const char *_S2);
char *    strcpy(char *_S1, const char *_S2);
size_t    strcspn(const char *_S1, const char *_S2);
char *    strerror(int _Errnum);
size_t    strlen(const char *_S);
char *    strncat(char *_S1, const char *_S2, size_t _N);
int       strncmp(const char *_S1, const char *_S2, size_t _N);
char *    strncpy(char *_S1, const char *_S2, size_t _N);
char *    strpbrk(const char *_S1, const char *_S2);
char *    strrchr(const char *_S, int _C);
size_t    strspn(const char *_S1, const char *_S2);
char *    strstr(const char *_S1, const char *_S2);
char *    strtok(char *_S1, const char *_S2);
size_t    strxfrm(char *_S1, const char *_S2, size_t _N);

#ifdef __NDPX__         /* C++ */
   }
#endif

#else                           /* K&R */

void *    memchr();
int       memcmp();
void *    memcpy();
void *    memmove();
void *    memset();
char *    strcat();
char *    strchr();
int       strcmp();
int       strcoll();
char *    strcpy();
size_t    strcspn();
char *    strerror();
size_t    strlen();
char *    strncat();
int       strncmp();
char *    strncpy();
char *    strpbrk();
char *    strrchr();
size_t    strspn();
char *    strstr();
char *    strtok();
size_t    strxfrm();

#endif  /* __STDC__ || __NDPX__ */
#endif    /* _STRING_H */

