/*  
**  ststream.h		C++ Runtime
**
**  Copyright (C)	Microway, Inc. 1987 - 1994.
**			P.O. BOX 79
**			Kingston, MA. 02364
**			(508) 746 - 7341 Voice
**			(508) 746 - 4678 FAX
**			e-mail tech@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef __STDIOSTREAM_H
# define __STDIOSTREAM_H
# include <stdio.h>
# include <iostream.h>
# ifdef __cppv21
#  define __ios ios::
# else
#  define __ios
# endif

class stdiobuf : public streambuf {
public:
		stdiobuf()		{ _f=NULL; _unbuff=1; }
		stdiobuf(FILE *f)	{ _f=f; _unbuff=1; }
    stdiobuf *	attach(FILE *f) 	{ if ( f==NULL ) {
					    if ( _f!=NULL )
						sync();
					  } else if ( _f!=NULL )
					    return NULL;
					  _f = f;
					  return( this );
					}
    FILE *	stdiofile()		{ return _f; }

    streampos	seekoff(streamoff off, __ios seek_dir m, int)
					{ sync(); return( ::fseek(_f,off,m)); }
   virtual	~stdiobuf()		{ sync(); }
   virtual int	underflow();
   virtual int	overflow(int =EOF);
   virtual int	sync();
   virtual int	pbackfail(int);

protected:
    FILE *	_f;
};

//This seems very silly.  Why don't we derive from istream/ostream?
//  This is useless, but it's consistant...
/*
class stdiostream : public ios {
protected:
    stdiobuf	buf;
public:
		stdiostream(FILE *f): buf(f)  { init(&buf); }
		~stdiostream()		      { buf.sync(); ::fclose(buf.stdiofile());}
    stdiobuf *	rdbuf() 		      { return( &buf );}
};
*/
# undef __ios
#endif
