/*  
**  dirent.h		ANSI C++, ANSI C, and K&R Runtime Library
**
**  Copyright (C)	Microway, Inc. 1987 - 1994.
**			P.O. BOX 79
**			Kingston, MA. 02364
**			(508) 746 - 7341 Voice
**			(508) 746 - 4678 FAX
**			e-mail uunet!microway!mark
**			       mark@microway.com
**
**  This program is the property of Microway, Inc, its contents are
**  proprietary information and no part of it is to be disclosed to anyone
**  except employees of Microway, Inc., or as agreed in writing by the
**  President of Microway, Inc.
*/

#ifndef _DIRENT_H
#define _DIRENT_H

struct dirent {
	/* These initial entries are for compatibility with cc. */
	long d_ino;		/* inode number of entry */
	off_t d_off;		/* offset of disk direntory entry */
	unsigned short d_reclen;	/* length of this record */

	char d_name[FILENAME_MAX];	/* name of file */
	char attribute;
	short time;
	short date;
	long size;
};

struct dir {
	/* These initial entries are for compatibility with cc. */
	int dd_fd;			/* file descriptor */
	int dd_loc;			/* offset in block */
	int dd_size;		/* amount of valid data */
	char *dd_buf;		/* directory block */
	struct dirent *entry;
	char *dirname;
} DIR;

#if defined(__STDC__) || defined(__NDPX__)
#ifdef __NDPX__			/* C++ */
   extern "C" {
#endif

struct dir *	opendir(char *);
struct dirent * readdir(struct dir *);
void 		rewinddir(struct dir *);
void 		closedir(struct dir *);

#ifdef __NDPX__			/* C++ */
   }
#endif

#else				/* K&R */

struct dir *	opendir();
struct dirent *	readdir();
void 		rewinddir();
void 		closedir();

#endif
#endif	/* _DIRENT_H */








