# DOS.MAK - makefile for tinytcp for DOS, using Microsoft C 6.0a compiler
# 931208 rr orig file
# 940513 rr minor mods
# 951011 rr changes to archives

# DOS I always use large model.
# Note: don't use Gs until all the bugs are out.

CC = \c600\bin\cl -AL -W3 -WX -Ox -Gs -G2 -Zpe -I\c600\include
LINK = \c600\binb\link

CFILES1 = addz.c arp.c fileio.c main.c sed.c sedslip.c test.c
CFILES2 = tinyftp.c tinyft2.c tinyft3.c tinyft4.c tinyft5.c
CFILES3 = tinytc1.c tinytc2.c tinytc3.c tinytc4.c tinytc5.c tinytc6.c
HFILES = casyncms.h fileio.h options.h proto.h sed.h tinytcp.h
ASMFILES = casyncms.asm room.as room.mac xsio.as xsio.mac
EXEFILES = addz.exe test.exe
BATFILES = bu.bat d.bat graph.bat l1.sub makecpm.sub zip.cmd
MAKFILES = dos.mak netscpm.rsp
DOCFILES = readme.txt

all: nets.exe

archives: tinytcp.zip tinytcp.sha

# ----- net.exe -----------------------------------------------------

# net.exe: arp.dbj sed.dbj tinyftp.dbj tinytcp.dbj main.dbj fileio.dbj
#	$(LINK) /NOD arp.dbj sed.dbj tinyftp.dbj tinytcp.dbj \
#		main.dbj fileio.dbj, \
#		net.exe, \
#		NUL,\c600\lib\llibcer;

# ----- nets.exe ----------------------------------------------------

# SLIP client/server. Does not need arp

# nets.exe: sedslip.dbj tinyftp.dbj tinytcp.dbj main.dbj \
#	casyncms.obj fileio.dbj
#	$(LINK) /NOD sedslip.dbj tinyftp.dbj tinytcp.dbj \
#		casyncms.obj main.dbj fileio.dbj, \
#		nets.exe, \
#		NUL,\c600\lib\llibcer;

nets.exe: main.dbj sedslip.dbj \
	tinyftp.dbj tinyft2.dbj tinyft3.dbj tinyft4.dbj tinyft5.dbj \
	tinytc1.dbj tinytc2.dbj tinytc3.dbj tinytc4.dbj tinytc5.dbj \
	tinytc6.dbj \
	casyncms.obj fileio.dbj
	$(LINK) /NOD @nets.rsp

# ----- test.exe ----------------------------------------------------

test.exe: test.dbj casyncms.obj
	$(LINK) /NOD test.dbj casyncms.obj,test.exe,NUL,\c600\lib\llibcer;

# ----- zip file ----------------------------------------------------

tinytcp.zip: $(DOCFILES) \
	$(BATFILES) \
	$(HFILES) \
	$(CFILES1) \
	$(CFILES2) \
	$(CFILES3) \
	$(ASMFILES) \
	$(MAKFILES) \
	$(EXEFILES)
	erase tinytcp.zip
	pkzip -a tinytcp.zip $(DOCFILES)
	pkzip -a tinytcp.zip $(BATFILES)
	pkzip -a tinytcp.zip $(HFILES)
	pkzip -a tinytcp.zip $(CFILES1)
	pkzip -a tinytcp.zip $(CFILES2)
	pkzip -a tinytcp.zip $(CFILES3)
	pkzip -a tinytcp.zip $(ASMFILES)
	pkzip -a tinytcp.zip $(MAKFILES)
	pkzip -a tinytcp.zip $(EXEFILES)

# ----- shar files --------------------------------------------------

tinytcp.sha: $(DOCFILES) \
	$(BATFILES) \
	$(HFILES) \
	$(CFILES1) \
	$(CFILES2) \
	$(CFILES3) \
	$(ASMFILES) \
	$(MAKFILES)
	sshar $(DOCFILES) >tinytcp.sha
	sshar $(BATFILES) >tinytc2.sha
	sshar $(HFILES) >tinytc3.sha
	sshar $(CFILES1) >tinytc4.sha
	sshar $(CFILES2) >tinytc5.sha
	sshar $(CFILES3) >tinytc6.sha
	sshar $(ASMFILES) >tinytc7.sha
	sshar $(MAKFILES) >tinytc8.sha

# ===== object files ================================================

arp.dbj: arp.c tinytcp.h sed.h proto.h options.h
	$(CC) -Foarp.dbj -c arp.c

sed.dbj: sed.c tinytcp.h sed.h proto.h options.h
	$(CC) -Fosed.dbj -c sed.c

sedslip.dbj: sedslip.c tinytcp.h sed.h proto.h options.h
	$(CC) -Fosedslip.dbj -c sedslip.c

tinyftp.dbj: tinyftp.c tinytcp.h sed.h proto.h fileio.h options.h
	$(CC) -Fotinyftp.dbj -c tinyftp.c

tinyft2.dbj: tinyft2.c tinytcp.h sed.h proto.h fileio.h options.h
	$(CC) -Fotinyft2.dbj -c tinyft2.c

tinyft3.dbj: tinyft3.c tinytcp.h sed.h proto.h fileio.h options.h
	$(CC) -Fotinyft3.dbj -c tinyft3.c

tinyft4.dbj: tinyft4.c tinytcp.h sed.h proto.h fileio.h options.h
	$(CC) -Fotinyft4.dbj -c tinyft4.c

tinyft5.dbj: tinyft5.c tinytcp.h sed.h proto.h fileio.h options.h
	$(CC) -Fotinyft5.dbj -c tinyft5.c

tinytc1.dbj: tinytc1.c tinytcp.h sed.h proto.h options.h
	$(CC) -Fotinytc1.dbj -c tinytc1.c

tinytc2.dbj: tinytc2.c tinytcp.h sed.h proto.h options.h
	$(CC) -Fotinytc2.dbj -c tinytc2.c

tinytc3.dbj: tinytc3.c tinytcp.h sed.h proto.h options.h
	$(CC) -Fotinytc3.dbj -c tinytc3.c

tinytc4.dbj: tinytc4.c tinytcp.h sed.h proto.h options.h
	$(CC) -Fotinytc4.dbj -c tinytc4.c

tinytc5.dbj: tinytc5.c tinytcp.h sed.h proto.h options.h
	$(CC) -Fotinytc5.dbj -c tinytc5.c

tinytc6.dbj: tinytc6.c tinytcp.h sed.h proto.h options.h
	$(CC) -Fotinytc6.dbj -c tinytc6.c

main.dbj: main.c tinytcp.h sed.h proto.h options.h
	$(CC) -Fomain.dbj -c main.c

fileio.dbj: fileio.c proto.h fileio.h options.h
	$(CC) -Fofileio.dbj -c fileio.c

test.dbj: test.c proto.h casyncms.h options.h
	$(CC) -Fotest.dbj -c test.c

casyncms.obj: casyncms.asm
	masm casyncms;

# ----- addz --------------------------------------------------------
# Addz is a utility to append a control-Z to a source file. The reason
# for this is that the CP/M emulator pads files to 128-byte boundaries
# with nulls or garbage, and this results in compiler and/or assembler
# errors.

addz.exe: addz.c
	$(CC) -Foaddz.dbj -c addz.c
	$(LINK) /NOD addz.dbj,addz.exe,NUL,c:\c600\lib\llibcer;
	erase addz.dbj

# end of dos.mak
