/* FILEIO.C - simple file I/O routines for portability
	940513	rr	orig file

The purpose of this routine is portability. All file I/O will be confined
	to this module.
*/

/* ----- include files ---------------------------------------------- */

#include "tinytcp.h"	/* for the P() macro */

#include "fileio.h"

#include <stdio.h>
#include <string.h>

/* ----- internals -------------------------------------------------- */

static char *fixup_filename P(( char *p_filename ));

/* ----- my_open ---------------------------------------------------- */

FH	my_open( p_filename, open_mode ) char *p_filename; int open_mode; {

	FILE	*p_file;

	/* At this point, we may wish to do some work on the filename. */

	p_filename = fixup_filename( p_filename );

	switch( open_mode ) {

	case MY_OPEN_READ:
		p_file = fopen( p_filename, "rb" );	/* Microsoft */
		return ( FH ) p_file;

	case MY_OPEN_WRITE:
		p_file = fopen( p_filename, "wb" );	/* Microsoft */
		return ( FH ) p_file;

	default:
		return ( FH ) 0;
	}
}

/* ----- close the file --------------------------------------------- */

Void	my_close( fh ) FH fh; {

	fclose(( FILE * ) fh );
}

/* ----- read bytes of file ----------------------------------------- */

unsigned short my_read( fh, p_buffer, u_bytes )
	FH fh; unsigned char *p_buffer; unsigned short u_bytes; {

	return fread( p_buffer, 1, u_bytes, ( FILE * ) fh );
}

/* ----- write bytes of file ---------------------------------------- */

unsigned short my_write( fh, p_buffer, u_bytes )
	FH fh; unsigned char *p_buffer; unsigned short u_bytes; {

	return fwrite( p_buffer, 1, u_bytes, ( FILE * ) fh );
}

/* ----- internal to fix up filename -------------------------------- */

static char *fixup_filename( p_filename ) char *p_filename; {

	char *		p;
	char		c;
	static	char	fixed_filename[ 42 ];
	int		dots;

	/* Here, I just move to the character after the last slash
		or forward slash. */

	p = strrchr( p_filename, '/' );
	if( p != ( char * ) 0 ) p_filename = p + 1;

	p = strrchr( p_filename, '\\' );
	if( p != ( char * ) 0 ) p_filename = p + 1;

	/* Force it into 8.3 style, uppercase only, one dot only */

	dots = 0;
	p = &fixed_filename[ 0 ];
	while( *p_filename ) {

		c = *p_filename++;

		if(( c <= ' ' ) || ( c > 126 )) continue;
 
		if(( c >= 'a' ) && ( c <= 'z' )) c -= ( 'a' - 'A' );
		/* else if( c == '/' ) c = '\\'; */
		else if( c == '.' ) {
			++dots;
			if( dots > 1 ) break;
		}

		/* could check for bad characters too. */

		*p++ = c;
	}

	return &fixed_filename[ 0 ];
}

/* end of fileio.c */
