/* TINYFT5.C - Part 5 of tiny FTP.
	941012	rr	split into parts
*/

/* #define DEBUG_FTP */

#define	RECEIVE_DATA_PORT	0x8080

	/* This is working now. */
/* #define	IMMEDIATE_OPEN */

#include "tinytcp.h"
#include "fileio.h"

#include <stdio.h>	/* for printf, etc */

#include <conio.h>	/* for kbhit, etc. Amazingly, Hitech C has these
				entry points too! */

#include <string.h>	/* for strcpy, etc. */

	/* the following are what these seem to be */

#define	isina		kbhit
#define	busyina		getch
#define busyouta	putch

	/* Sockets */

extern	struct tcp_Socket s_og_ctl,	/* outgoing connection socket */
			s_og_data,	/* data socket */
			s_ic_ctl,	/* server control socket */
			s_ic_data;	/* server data socket */

	/* Receive buffer for client side. */

extern	char		b_response[ 120 ];	/* response buffer */
extern	int		i_response;		/* index into response buf */

	/* Client output command buffer */

extern	char		b_c_command[ 82 ];	/* send buffer */

	/* Server output buffer */

extern	char		b_s_response[ 128 ];
					/* server output buffer */

	/* Server file transfer buffer, index, and length */

extern	Byte		b_s_data[ 1024 ];	/* server output buffer */
extern	int		n_s_sent,	/* bytes sent of buffer */
			n_s_left;	/* bytes left in serv2 buffer */

	/* file handle for retrieve */

extern	char		recv_filename[ 82 ];
extern	FH		p_recv_file;

	/* file handle for server */

extern	char		send_filename[ 82 ];
extern	FH		p_send_file;

/* ----- prototypes ------------------------------------------------- */

extern void exit P(( int ));


/* ----- process local command -------------------------------------- */

Void ftp_local_command( s ) char *s; {
	S8	IP_Address	host;

	if( *s++ != '@' ) return;

	if( *s == 'o' ) {			/* @open */

		host = ( IP_Address ) HOST_ADDR;
				/* 0xC009C802; */
				/* IP addr of host to call */
				/* 192.9.201.2 tritium */

#ifndef IMMEDIATE_OPEN
		/* Open connection for messages and commands going out */

		tcp_Open( &s_og_ctl,		/* socket */
			RECEIVE_DATA_PORT,	/* my port */
			host,			/* host to call */
			21,			/* his port (hailing freq.) */
			( Procref ) ftp_ctlHandler );	/* handler */
#endif	/* IMMEDIATE_OPEN */

	} else if( *s == 'c' ) {		/* @close */

		if( p_recv_file != ( FH ) 0 ) {
			my_close( p_recv_file );
			p_recv_file = ( FH ) 0;
		}

		tcp_Abort( &s_og_ctl );
		tcp_Abort( &s_og_data );

	} else if( *s == 'q' ) {		/* @quit */

		if( p_recv_file != ( FH ) 0 ) {
			my_close( p_recv_file );
			p_recv_file = ( FH ) 0;
		}

		exit( 0 );		/* get out quick! */
	}
}

/* end of tinyft5.c */
