/* TINYTC2.C - Tiny-TCP source fragment
	Part 2 of the TCP layer.
	941012	rr	split into fragments
*/

#include "tinytcp.h"

#include <stdio.h>

#ifdef PC
#include <string.h>
#endif

/* ----- globals from tinytcp.c ------------------------------------- */

extern	IP_Address	local_IP_address;	/* local IP address */

extern	int		tcp_id;			/* TCP ID, gets incremented */

extern	struct tcp_Socket *	tcp_allsocs;	/* socket linklist */

/* ----- tcp listen ------------------------------------------------- */

/* Passive open: listen for a connection on a particular port */

Void tcp_Listen( s, port, datahandler, timeout )
	struct	tcp_Socket *	s;
	Word			port;
#ifdef USE_TYPEDEFS
	Procref			datahandler;
#else
	int ( *datahandler ) P(( void *s, Byte *dp, int len ));
#endif
	Longword		timeout;
{
	s -> state = TS_LISTEN;

	if( timeout == 0L ) s -> timeout = 0x7FFFFFFL; /* forever... */
	else	s -> timeout = timeout;

	s -> myport = port;
	s -> hisport = 0;
	s -> seqnum = 0;
	s -> dataSize = 0;
	s -> flags = 0;
	s -> unhappy = 0;
	s -> dataHandler = datahandler;

	/* Add it to the linklist */

	s -> next = tcp_allsocs;
	tcp_allsocs = s;
}

/* end of tinytc2.c */
