/* TINYFT4.C - Part 4 of tiny FTP.

 * Copyright (C) 1986, IMAGEN Corporation
 * "This code may be duplicated in whole or in part provided that [1] there
 * is no commercial gain involved in the duplication, and [2] that this
 * copyright notice is preserved on all copies. Any other duplication
 * requires written notice of the author."

|===================================================================|
|  The author of this code hereby licenses all duplication and/or   |
|  modification of this code, in whole or in part, consistent with  |
|  the terms of the GNU Library General Public License.             |
|              - Geoffrey H. Cooper 10/29/97                        |
|===================================================================|

|===================================================================|
|  My changes can be considered public domain.  Geof's statement    |
|  will cover everything.                                           |
|              - Rick Rodman 09/02/97                               |
|===================================================================|

	941012	rr	split into 4 parts
*/

/* #define DEBUG_FTP */

#define	RECEIVE_DATA_PORT	0x8080

	/* This is working now. */
/* #define	IMMEDIATE_OPEN */

#include "tinytcp.h"
#include "fileio.h"

#include <stdio.h>	/* for printf, etc */

#include <conio.h>	/* for kbhit, etc. Amazingly, Hitech C has these
				entry points too! */

#include <string.h>	/* for strcpy, etc. */

	/* the following are what these seem to be */

#define	isina		kbhit
#define	busyina		getch
#define busyouta	putch

	/* Sockets */

extern	struct tcp_Socket s_og_ctl,	/* outgoing connection socket */
			s_og_data,	/* data socket */
			s_ic_ctl,	/* server control socket */
			s_ic_data;	/* server data socket */

	/* Receive buffer for client side. */

extern	char		b_response[ 120 ];	/* response buffer */
extern	int		i_response;		/* index into response buf */

	/* Client output command buffer */

extern	char		b_c_command[ 82 ];	/* send buffer */

	/* Server output buffer */

extern	char		b_s_response[ 128 ];
					/* server output buffer */

	/* Server file transfer buffer, index, and length */

extern	Byte		b_s_data[ 1024 ];	/* server output buffer */
extern	int		n_s_sent,	/* bytes sent of buffer */
			n_s_left;	/* bytes left in serv2 buffer */

	/* file handle for retrieve */

extern	char		recv_filename[ 82 ];
extern	FH		p_recv_file;

	/* file handle for server */

extern	char		send_filename[ 82 ];
extern	FH		p_send_file;

/* ----- prototypes ------------------------------------------------- */

extern void exit P(( int ));

/* ----- ftp -------------------------------------------------------- */

Void ftp( host ) IP_Address host; {

	i_response = 0;

	/* Set up listen for FTP server */

	tcp_Listen( &s_ic_ctl,	/* socket */
		21,			/* my port */
		( Procref ) ftp_server_handler,	/* handler */
		0L );			/* timeout = forever */

	/* Set up listen for data coming back. (Do we have to
		do a new Listen everytime this socket gets closed?) */

	tcp_Listen( &s_og_data,		/* socket */
		RECEIVE_DATA_PORT,	/* my port */
		( Procref ) ftp_dataHandler,	/* handler */
		0L );			/* timeout = forever */

#ifdef IMMEDIATE_OPEN
	/* If a host IP address was passed, open the other end. */

	if( host != 0L ) {
		/* Open connection for messages and commands going out */

		/* NOTE: This is usually only done when an 'Open' command is
			issued. */

		tcp_Open( &s_og_ctl,		/* socket */
			RECEIVE_DATA_PORT,	/* my port */
			host,			/* host to call */
			21,			/* his port (hailing freq.) */
			( Procref ) ftp_ctlHandler );	/* handler */
	}
#endif /* IMMEDIATE OPEN */

	tcp( ftp_application );
}

/* end of tinyft4.c */

