/* TINYTC2.C - Tiny-TCP source fragment
	Part 2 of the TCP layer.

 * Copyright (C) 1986, IMAGEN Corporation
 * "This code may be duplicated in whole or in part provided that [1] there
 * is no commercial gain involved in the duplication, and [2] that this
 * copyright notice is preserved on all copies. Any other duplication
 * requires written notice of the author."

|===================================================================|
|  The author of this code hereby licenses all duplication and/or   |
|  modification of this code, in whole or in part, consistent with  |
|  the terms of the GNU Library General Public License.             |
|              - Geoffrey H. Cooper 10/29/97                        |
|===================================================================|

|===================================================================|
|  My changes can be considered public domain.  Geof's statement    |
|  will cover everything.                                           |
|              - Rick Rodman 09/02/97                               |
|===================================================================|

	941012	rr	split into fragments
*/

#include "tinytcp.h"

#include <stdio.h>

#ifdef PC
#include <string.h>
#endif

/* ----- globals from tinytcp.c ------------------------------------- */

extern	IP_Address	local_IP_address;	/* local IP address */

extern	int		tcp_id;			/* TCP ID, gets incremented */

extern	struct tcp_Socket *	tcp_allsocs;	/* socket linklist */

/* ----- tcp listen ------------------------------------------------- */

/* Passive open: listen for a connection on a particular port */

Void tcp_Listen( s, port, datahandler, timeout )
	struct	tcp_Socket *	s;
	Word			port;
#ifdef USE_TYPEDEFS
	Procref			datahandler;
#else
	int ( *datahandler ) P(( void *s, Byte *dp, int len ));
#endif
	Longword		timeout;
{
	s -> state = TS_LISTEN;

	if( timeout == 0L ) s -> timeout = 0x7FFFFFFL; /* forever... */
	else	s -> timeout = timeout;

	s -> myport = port;
	s -> hisport = 0;
	s -> seqnum = 0;
	s -> dataSize = 0;
	s -> flags = 0;
	s -> unhappy = 0;
	s -> dataHandler = datahandler;

	/* Add it to the linklist */

	s -> next = tcp_allsocs;
	tcp_allsocs = s;
}

/* end of tinytc2.c */

