# partial unit test for gmpy 1.01 extra cover
# relies on Tim Peters' "doctest.py" test-driver
# test-version 1.01
r'''
>>> print int(_g.gmp_version() in ('4.1.4', '4.1.2', '4.0.1', '3.1.1'))
1
>>> _g.version()
'1.01'
'''

import gmpy as _g, doctest, sys
__test__={}
r = _g.rand

__test__['misc_stuff']=\
r'''
>>> junk=_g.set_debug(0)
>>> knuj=_g.set_debug(junk)
>>> junk==_g.set_debug(junk)
1
>>> _g.set_fcoform(None)
>>> _g.set_fcoform()
>>> print _g.mpf(3.0)
3.0
>>> 
'''

__test__['user_errors']=\
r'''
>>> _g.version(23)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: function takes exactly 0 arguments (1 given)
>>> _g.gmp_version(23)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: function takes exactly 0 arguments (1 given)
>>> _g.get_zcache(23)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: function takes exactly 0 arguments (1 given)
>>> _g.set_zcache(2000)
Traceback (most recent call last):
  File "<string>", line 1, in ?
ValueError: cache must between 0 and 1000
>>> _g.set_zcache(-23)
Traceback (most recent call last):
  File "<string>", line 1, in ?
ValueError: cache must between 0 and 1000
>>> _g.get_qcache(23)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: function takes exactly 0 arguments (1 given)
>>> _g.set_qcache(2000)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: cache must between 0 and 1000
>>> _g.set_qcache(-42)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: cache must between 0 and 1000
>>> _g.get_zconst(23)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: function takes exactly 0 arguments (1 given)
>>> _g.set_zconst()
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: function takes exactly 2 arguments (0 given)
>>> _g.set_zconst(23)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: function takes exactly 2 arguments (1 given)
>>> _g.set_zconst(23,45,67)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: function takes exactly 2 arguments (3 given)
>>> _g.set_zconst(23,'blub')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: an integer is required
>>> _g.set_zconst(-1000,1000)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: cache must between 0 and 1000
>>> _g.set_zconst(100,-100)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: cache must between 0 and 1000
>>> _g.set_debug()
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: function takes exactly 1 argument (0 given)
>>> _g.set_debug(2,3)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: function takes exactly 1 argument (2 given)
>>> _g.set_debug('boh')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: an integer is required
>>> _g.set_minprec(-1)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: minimum precision must be >= 0
>>> _g.set_fcoform(33)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: number of digits n must be 0<n<=30
>>> _g.set_fcoform([])
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: set_fcoform argument must be int, string, or None
>>> _g.mpz('12'+chr(0)+'34')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: string without NULL characters expected
>>> _g.mpf('12'+chr(0)+'34')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: string without NULL characters expected
>>> _g.mpq('12'+chr(0)+'34')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: string without NULL characters expected
>>> _g.mpq('bo',256)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: invalid mpq binary (too short)
>>> _g.mpq('bologna',256)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: invalid mpq binary (num len)
>>> _g.mpq('\001\000\000\000\003\002',256)
mpq(3,2)
>>> _g.mpq('\002\000\000\000\003\377\002',256)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: invalid mpq binary (num sgn)
>>> _g.mpq('\001\000\000\000\003\002\377',256)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: invalid mpq binary (den sgn)
>>> _g.mpq('ba/bo')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: invalid digits
>>> print 'ba/bo'
ba/bo
>>> _g.mpq('1/bo')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: invalid digits
>>> print '1/bo'
1/bo
>>> _g.mpq('1/0')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ZeroDivisionError: mpq: zero denominator
>>> _g.mpf([])
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: gmpy.mpf() expects numeric or string argument
>>> _g.mpf('bo',0,256)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: string too short to be a gmpy.mpf binary encoding
>>> _g.mpf('bo')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: invalid digits
>>> int(_g.mpz(1000*1000*1000*1000L)) 
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
OverflowError: mpz too large for int
>>> _g.scan0(12,-1)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: starting bit must be >= 0
>>> _g.scan1(12,-1)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: starting bit must be >= 0
>>> _g.lowbits(12,-1)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: nbits must be > 0
>>> _g.getbit(12,-1)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: bit_index must be >= 0
>>> _g.setbit(12,-1)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: bit_index must be >= 0
>>> _g.mpz(23).setbit(12,1,2,3)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: function takes at most 2 arguments (4 given)
>>> _g.setbit(12,1,2,3)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: function takes at most 3 arguments (4 given)
>>> _g.root(12,-1)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: n must be > 0
>>> _g.root(12,0)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: n must be > 0
>>> _g.root(-12,2)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: root of negative number
>>> _g.digits(3.14,'peep')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: an integer is required
>>> _g.fdigits(3.14,'peep')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: an integer is required
>>> _g.qdigits(3.14,'peep')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: an integer is required
>>> _g.mpz(3).digits('bu')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: an integer is required
>>> _g.mpf(3).digits('bu')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: an integer is required
>>> _g.qdiv(3,_g.mpq(1))
mpz(3)
>>> _g.qdiv(3,_g.mpz(1))
mpz(3)
>>> _g.qdiv(3,_g.mpf(1))
mpz(3)
>>> _g.qdiv(3,1.0)
mpz(3)
>>> _g.qdiv(3,1L)
mpz(3)
>>> _g.qdiv(3)
mpz(3)
>>> _g.qdiv(3,'bu')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: second argument to qdiv not a number
>>> _g.mpq(2).qdiv(3,4)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: function takes at most 1 argument (2 given)
>>> _g.qdiv(3,4,5)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: function takes at most 2 arguments (3 given)
>>> _g.qdiv('bu')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: first argument to qdiv not a number
>>> _g.qdiv(1.0,1)
mpz(1)
>>> _g.qdiv(1.0,0)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ZeroDivisionError: qdiv: zero divisor
>>> _g.f2q(-1.0)
mpz(-1)
>>> _g.mpz(1,2,3)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: gmpy.mpz() requires 1 or 2 arguments
>>> _g.mpz('bi','bo')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: gmpy.mpz(): base must be an integer
>>> _g.mpz('bi',99)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: base for gmpy.mpz must be 0, 256, or in the interval 2 ... 36 .
>>> _g.mpz(1,2)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: gmpy.mpz() with numeric argument needs exactly 1 argument
>>> _g.mpz(None)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: gmpy.mpz() expects numeric or string argument
>>> _g.mpq(1,2,3)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: gmpy.mpq() requires 1 or 2 arguments
>>> _g.mpq('bi','bo')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: gmpy.mpq(): base must be an integer
>>> _g.mpq('bi',99)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: base for gmpy.mpq() must be 0, 256, or in the interval 2 ... 36 .
>>> _g.mpq(None)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: gmpy.mpq() expects numeric or string argument
>>> _g.mpq(1,None)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: argument can not be converted to mpq
>>> _g.mpq(1,0)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ZeroDivisionError: mpq: zero denominator
>>> _g.mpf()
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: gmpy.mpf() requires 1 to 3 arguments
>>> _g.mpf(1,'bo')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: gmpy.mpf(): bits must be an integer
>>> _g.mpf(1,-1)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: bits for gmpy.mpf must be >= 0
>>> _g.mpf('ba',0,'bu')
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: gmpy.mpf(): base must be an integer
>>> _g.mpf('ba',0,99)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: base for gmpy.mpf must be 0, 256, or in the interval 2 ... 36 .
>>> _g.mpf(1,2,3)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: gmpy.mpf() with numeric 1st argument needs 1 or 2 arguments
>>> +_g.mpz(1)
mpz(1)
>>> +_g.mpf(1)
mpf('1.e0')
>>> +_g.mpq(1)
mpq(1)
>>> _g.mpz(2)**-2
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: mpz.pow with negative power
>>> _g.mpz(2)**_g.mpz(1000000*1000000L)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: mpz.pow outrageous exponent
>>> pow(_g.mpz(2),3,0)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: mpz.pow divide by zero
>>> pow(_g.mpz(2),3,-5)
mpz(-2)
>>> pow(_g.mpq(2),3,-5)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: mpq.pow no modulo allowed
>>> a=1000000L**2
>>> _g.mpq(2)**a
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: mpq.pow outrageous exp num
>>> _g.mpq(2)**_g.mpq(1,a)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: mpq.pow outrageous exp den
>>> _g.mpq(2)**0
mpq(1)
>>> _g.mpq(2)**-1
mpq(1,2)
>>> _g.mpq(2)**_g.mpq(1,2)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: mpq.pow fractional exponent, inexact-root
>>> _g.mpq(-2)**_g.mpq(1,2)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: mpq.pow fractional exponent, nonreal-root
>>> _g.mpq(0)**_g.mpq(1,2)
mpq(0)
>>> _g.mpq(0)**-1
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ZeroDivisionError: mpq.pow 0 base to <0 exponent
>>> _g.mpq(-1)**-1
mpq(-1)
>>> _g.mpf(9,100)**2
mpf('8.1e1',100)
>>> _g.mpf(9,100)**0.5
mpf('3.e0',100)
>>> _g.mpf(9,100)**_g.mpf(0.5)
mpf('3.e0')
>>> pow(_g.mpf(2),3,-5)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: mpf.pow no modulo allowed
>>> _g.mpz(1)+'bu'
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: coercion to gmpy.mpz type failed
>>> _g.mpz(1)+_g.mpf(1)
mpf('2.e0')
>>> _g.mpz(1)+_g.mpq(1)
mpq(2)
>>> _g.mpq(1)+'bu'
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: coercion to gmpy.mpq type failed
>>> _g.mpf(1)+'bu'
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
TypeError: coercion to gmpy.mpf type failed
>>> _g.mpf(1)+_g.mpq(2)
mpq(3)
>>> divmod(_g.mpz(3),0)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ZeroDivisionError: mpz.divmod by zero
>>> divmod(_g.mpz(0),3)
(mpz(0), mpz(0))
>>> _g.divm(1,2,0)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ZeroDivisionError: not invertible
>>> abs(_g.mpq(0))
mpq(0)
>>> _g.mpz(0)**2
mpz(0)
>>> _g.mpq(-2)**0
mpq(1)
>>> _g.fac(-1)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: factorial of negative number
>>> _g.fib(-1)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: Fibonacci of negative number
>>> _g.comb(7,-3)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: binomial coefficient with negative k
>>> _g.sqrt(-1)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: sqrt of negative number
>>> _g.sqrtrem(-1)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: sqrt of negative number
>>> _g.fsqrt(-1)
Traceback (most recent call last):
  File "<stdin>", line 1, in ?
ValueError: sqrt of negative number
'''

def _test(chat=None):
    if chat:
        print "Unit tests for gmpy 1.01 release candidate (extra cover)"
        print "    running on Python",sys.version
        print
        print "Testing gmpy %s (GMP %s) with default caching" \
            "(%s, %s, %s..%s)" % (
            (_g.version(), _g.gmp_version(), _g.get_zcache(), _g.get_qcache(),
            ) + _g.get_zconst())
    thismod = sys.modules.get(__name__)
    doctest.testmod(thismod, report=0)

    if chat: print "Repeating tests, with empty callbacks"

    def _zd(where,*args):
        if where=='qdiv':
            raise ZeroDivisionError, "qdiv: zero divisor"
        elif where=='mpz_divmod':
            raise ZeroDivisionError, "mpz.divmod by zero"
        elif where=='mpq_pow':
            raise ZeroDivisionError, "mpq.pow 0 base to <0 exponent"
        elif where=='divm':
            raise ZeroDivisionError, "not invertible"
        else:
            raise ZeroDivisionError, "mpq: zero denominator"

    def _zm(*args):
        return None

    def _at(self,name):
        return name.upper()

    def _er(where, what, *args):
        raise ValueError, what

    _g.set_callback('ZM',_zm)
    _g.set_callback('ZD',_zd)
    _g.set_callback('ER',_er)
    _g.set_callback('AT',_at)

    class _Fakenum:
        def __gmpy__(self, where, args, other, extype, exvalue):
            raise extype, exvalue
    _fn = _Fakenum()
    try: x = _g.getbit(_fn,17)
    except TypeError: pass
    try: x = _g.divm(23,45,_fn)
    except TypeError: pass

    assert(_g.mpz(23).foop=='FOOP')
    assert(_g.mpq(23).foop=='FOOP')
    assert(_g.mpf(23).foop=='FOOP')

    # avoid merge-reports for the second run
    sav = sys.stdout
    class _Dummy:
        def write(self,*whatever):
            pass
    try:
        sys.stdout = _Dummy()
        doctest.testmod(thismod, report=0)
    finally:
        sys.stdout = sav

    # just generate a little extra coverage...!
    _g.set_callback('ZM')
    _g.set_callback('ZD',None)
    _g.set_callback('ER')
    _g.set_callback('AT')
    try: _g.set_callback('ZD',23,45)
    except: pass
    try: _g.set_callback('ZD',23)
    except: pass
    try: _g.set_callback('ZZ')
    except: pass

    if chat:
        print
        print "Overall results for cvr:"
    return doctest.master.summarize(chat)

if __name__=='__main__':
    _test(1)
    if sys.platform == 'win32':
        print 'NOTE: known bugs with scan0 and scan1 on Windows'
        print 'they are being investigated, no need to report, thanks'
