/*
  ==============================================================================

   This file is part of the JUCE library - "Jules' Utility Class Extensions"
   Copyright 2004-6 by Raw Material Software ltd.

  ------------------------------------------------------------------------------

   JUCE can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   JUCE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with JUCE; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ------------------------------------------------------------------------------

   If you'd like to release a closed-source product which uses JUCE, commercial
   licenses are also available: visit www.rawmaterialsoftware.com/juce for
   more information.

  ==============================================================================
*/

#ifndef __JUCE_MENUBARMODEL_JUCEHEADER__
#define __JUCE_MENUBARMODEL_JUCEHEADER__

#include "juce_PopupMenu.h"
class MenuBarComponent;


//==============================================================================
/**
    A class for controlling MenuBar components.

    This class is used to tell a MenuBar what menus to show, and to respond
    to a menu being selected.

    @see MenuBar, PopupMenu
*/
class JUCE_API  MenuBarModel
{
public:
    //==============================================================================
    MenuBarModel() throw()          {}

    /** Destructor. */
    virtual ~MenuBarModel()         {}

    //==============================================================================
    /** This method must return a list of the names of the menus. */
    virtual const StringArray getMenuBarNames (MenuBarComponent* menuBar) = 0;

    /** This should return the popup menu to display for a given top-level menu.

        @param menuBar              the MenuBar that's interested
        @param topLevelMenuIndex    the index of the top-level menu to show
        @param menuName             the name of the top-level menu item to show
    */
    virtual const PopupMenu getMenuForIndex (MenuBarComponent* menuBar,
                                             int topLevelMenuIndex,
                                             const String& menuName) = 0;

    /** This is called when a menu item has been clicked on.

        @param menuBar              the MenuBar that was used
        @param menuItemID           the item ID of the PopupMenu item that was selected
        @param topLevelMenuIndex    the index of the top-level menu from which the item was
                                    chosen (just in case you've used duplicate ID numbers
                                    on more than one of the popup menus)
    */
    virtual void menuItemSelected (MenuBarComponent* menuBar,
                                   int menuItemID,
                                   int topLevelMenuIndex) = 0;
};


#endif   // __JUCE_MENUBARMODEL_JUCEHEADER__
