/*
  ==============================================================================

   This file is part of the JUCE library - "Jules' Utility Class Extensions"
   Copyright 2004-6 by Raw Material Software ltd.

  ------------------------------------------------------------------------------

   JUCE can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   JUCE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with JUCE; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ------------------------------------------------------------------------------

   If you'd like to release a closed-source product which uses JUCE, commercial
   licenses are also available: visit www.rawmaterialsoftware.com/juce for
   more information.

  ==============================================================================
*/

#include "juce_StandardHeader.h"

BEGIN_JUCE_NAMESPACE


#include "../text/juce_String.h"
#include "juce_SystemStats.h"
#include "juce_Random.h"
#include "juce_Time.h"
#include "juce_Logger.h"
#include "../threads/juce_Thread.h"
#include "../text/juce_LocalisedStrings.h"

const tchar* SystemStats::MacOSX        = T("Mac OS X");
const tchar* SystemStats::Linux         = T("Linux");
const tchar* SystemStats::WinXP         = T("Windows XP");
const tchar* SystemStats::Win2000       = T("Windows 2000");
const tchar* SystemStats::Win95         = T("Windows 95");
const tchar* SystemStats::Win98         = T("Windows 98");
const tchar* SystemStats::WinNT351      = T("Windows NT 3.51");
const tchar* SystemStats::WinNT40       = T("Windows NT4");
const tchar* SystemStats::UnknownOS     = T("Unknown OS");


//==============================================================================
const String SystemStats::getJUCEVersion()
{
    return T("JUCE v") + String (JUCE_MAJOR_VERSION) + T(".") + String (JUCE_MINOR_VERSION);
}


//==============================================================================
static bool juceInitialisedNonGUI = false;

void JUCE_API initialiseJuce_NonGUI()
{
    if (! juceInitialisedNonGUI)
    {
        juceInitialisedNonGUI = true;

        DBG (SystemStats::getJUCEVersion());
        SystemStats::initialiseStats();
        Random::getSystemRandom().setSeed (Time::currentTimeMillis());
    }
}

void JUCE_API shutdownJuce_NonGUI()
{
    if (juceInitialisedNonGUI)
    {
        LocalisedStrings::setCurrentMappings (0);
        Thread::stopAllThreads (3000);

        juceInitialisedNonGUI = false;
    }
}

END_JUCE_NAMESPACE
