/*
  ==============================================================================

   This file is part of the JUCE library - "Jules' Utility Class Extensions"
   Copyright 2004-6 by Raw Material Software ltd.

  ------------------------------------------------------------------------------

   JUCE can be redistributed and/or modified under the terms of the
   GNU General Public License, as published by the Free Software Foundation;
   either version 2 of the License, or (at your option) any later version.

   JUCE is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with JUCE; if not, visit www.gnu.org/licenses or write to the
   Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
   Boston, MA 02111-1307 USA

  ------------------------------------------------------------------------------

   If you'd like to release a closed-source product which uses JUCE, commercial
   licenses are also available: visit www.rawmaterialsoftware.com/juce for
   more information.

  ==============================================================================
*/

#ifndef __JUCE_JUCE_CORE_INCLUDES_INCLUDEFILES__
#define __JUCE_JUCE_CORE_INCLUDES_INCLUDEFILES__

#include "juce_core/basics/juce_Atomic.h"
#include "juce_core/basics/juce_DataConversions.h"
#include "juce_core/basics/juce_FileLogger.h"
#include "juce_core/basics/juce_Initialisation.h"
#include "juce_core/basics/juce_Logger.h"
#include "juce_core/basics/juce_MathsFunctions.h"
#include "juce_core/basics/juce_Memory.h"
#include "juce_core/basics/juce_PlatformDefs.h"
#include "juce_core/basics/juce_Random.h"
#include "juce_core/basics/juce_RelativeTime.h"
#include "juce_core/basics/juce_Singleton.h"
#include "juce_core/basics/juce_StandardHeader.h"
#include "juce_core/basics/juce_SystemStats.h"
#include "juce_core/basics/juce_Time.h"
#include "juce_core/containers/juce_Array.h"
#include "juce_core/containers/juce_ArrayAllocationBase.h"
#include "juce_core/containers/juce_BitArray.h"
#include "juce_core/containers/juce_ElementComparator.h"
#include "juce_core/containers/juce_MemoryBlock.h"
#include "juce_core/containers/juce_OwnedArray.h"
#include "juce_core/containers/juce_PropertySet.h"
#include "juce_core/containers/juce_ReferenceCountedArray.h"
#include "juce_core/containers/juce_ReferenceCountedObject.h"
#include "juce_core/containers/juce_SortedSet.h"
#include "juce_core/containers/juce_SparseSet.h"
#include "juce_core/containers/juce_VoidArray.h"
#include "juce_core/io/juce_InputStream.h"
#include "juce_core/io/juce_OutputStream.h"
#include "juce_core/io/files/juce_DirectoryIterator.h"
#include "juce_core/io/files/juce_File.h"
#include "juce_core/io/files/juce_FileInputStream.h"
#include "juce_core/io/files/juce_FileOutputStream.h"
#include "juce_core/io/files/juce_FileSearchPath.h"
#include "juce_core/io/files/juce_NamedPipe.h"
#include "juce_core/cryptography/juce_BlowFish.h"
#include "juce_core/cryptography/juce_MD5.h"
#include "juce_core/cryptography/juce_Primes.h"
#include "juce_core/cryptography/juce_RSAKey.h"
#include "juce_core/io/network/juce_Socket.h"
#include "juce_core/io/network/juce_URL.h"
#include "juce_core/io/streams/juce_BufferedInputStream.h"
#include "juce_core/io/streams/juce_GZIPCompressorOutputStream.h"
#include "juce_core/io/streams/juce_GZIPDecompressorInputStream.h"
#include "juce_core/io/streams/juce_MemoryInputStream.h"
#include "juce_core/io/streams/juce_MemoryOutputStream.h"
#include "juce_core/io/streams/juce_SubregionStream.h"
#include "juce_core/misc/juce_PerformanceCounter.h"
#include "juce_core/misc/juce_PlatformUtilities.h"
#include "juce_core/misc/juce_Uuid.h"
#include "juce_core/misc/juce_ZipFile.h"
#include "juce_core/text/juce_LocalisedStrings.h"
#include "juce_core/text/juce_String.h"
#include "juce_core/text/juce_StringArray.h"
#include "juce_core/text/juce_StringPairArray.h"
#include "juce_core/text/juce_TextFunctions.h"
#include "juce_core/text/juce_XmlDocument.h"
#include "juce_core/text/juce_XmlElement.h"
#include "juce_core/threads/juce_CriticalSection.h"
#include "juce_core/threads/juce_InterProcessLock.h"
#include "juce_core/threads/juce_Process.h"
#include "juce_core/threads/juce_ReadWriteLock.h"
#include "juce_core/threads/juce_ScopedLock.h"
#include "juce_core/threads/juce_ScopedReadLock.h"
#include "juce_core/threads/juce_ScopedWriteLock.h"
#include "juce_core/threads/juce_Thread.h"
#include "juce_core/threads/juce_ThreadPool.h"
#include "juce_core/threads/juce_TimeSliceThread.h"
#include "juce_core/threads/juce_WaitableEvent.h"

#endif
