/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/include/gl/gl.h,v 1.5 2004/02/06 14:14:53 drgoldie Exp $
 *
\**************************************************************************/


#ifndef __GL_HEADERFILE__
#define __GL_HEADERFILE__


#include "../klMain.h"


// always get all constants definitions
//
#include "../gl_definitions.h"

// egl should be implemented on any platform
//

#include "../egl_definitions.h"

#ifdef __cplusplus
extern "C" {
#endif

// gl methods
GLenum glGetError();
void glMatrixMode(GLenum nMode);
void glLoadMatrixf(const GLfloat *nMatrix);
void glLoadMatrixd(const GLdouble *nMatrix);
void glLoadMatrixx(const GLfixed *nMatrix);
void glMultMatrixf(const GLfloat *nMatrix);
void glMultMatrixd(const GLdouble *nMatrix);
void glMultMatrixx(const GLfixed *nMatrix);
void glPushMatrix();
void glPopMatrix();
void glLoadIdentity();
void glTranslatef(GLfloat nX, GLfloat nY, GLfloat nZ);
void glTranslated(GLdouble nX, GLdouble nY, GLdouble nZ);
void glTranslatefv(GLfloat* nTrans);
void glTranslatex(GLfixed nX, GLfixed nY, GLfixed nZ);
void glScalef(GLfloat nX, GLfloat nY, GLfloat nZ);
void glScalex(GLfixed nX, GLfixed nY, GLfixed nZ);
void glRotatef(GLfloat nAngle, GLfloat nX, GLfloat nY, GLfloat nZ);
void glRotatex(GLfixed nAngle, GLfixed nX, GLfixed nY, GLfixed nZ);
void glOrtho(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble nearval, GLdouble farval);
void glOrthox(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed nearval, GLfixed farval);
void glFrustum(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble znear, GLdouble zfar);
void glFrustumx(GLfixed left, GLfixed right, GLfixed bottom, GLfixed top, GLfixed znear, GLfixed zfar);

void glEnableClientState(GLenum nState);
void glDisableClientState(GLenum nState);
void glColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void glNormalPointer(GLenum type, GLsizei stride, const GLvoid *pointer);
void glTexCoordPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void glVertexPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
void glDrawElements(GLenum polymode, GLsizei count, GLenum datatype, const GLvoid *indices);

void glClearColor(GLfloat nR, GLfloat nG, GLfloat nB, GLfloat nA);
void glClearColorx(GLfixed nR, GLfixed nG, GLfixed nB, GLfixed nA);
void glClearDepth(GLdouble nDepth);
void glClearDepthx(GLfixed nDepth);
void glClear(GLint nFlags);
void glColorMask(GLboolean nRed, GLboolean nGreen, GLboolean nBlue, GLboolean nAlpha);
void glPolygonMode(GLenum nSide, GLenum nPoly);
void glEnable(GLenum nSelect);
void glDisable(GLenum nSelect);
GLboolean glIsEnabled(GLenum nSelect);
void glDepthMask(GLboolean nSet);
void glCullFace(GLenum nCull);
void glFrontFace(GLenum nFace);
void glGetBooleanv(GLenum nType, GLboolean *nParams);
void glGetFloatv(GLenum nType, GLfloat* nParams);
void glGetIntegerv(GLenum nType, GLint* nParams);
const char* glGetString(GLenum nName);
void glScissor(GLint x, GLint y, GLsizei width, GLsizei height);
void glFogi(GLenum pname, GLint param);
void glFogf(GLenum pname, GLfloat param);
void glFogfv(GLenum pname, const GLfloat *params);
void glFogiv(GLenum pname, const GLint *params);
void glBlendFunc(GLenum sfactor, GLenum dfactor);
void glDepthFunc(GLenum nFunc);

void glLightfv(GLenum nLight, GLenum nSelect, const GLfloat* nValues);
void glLightxv(GLenum nLight, GLenum nSelect, const GLfixed* nValues);
void glLightModeli(GLenum nParam, GLint nValue);
void glLightModelf(GLenum nParam, GLfloat nValue);
void glLightModelx(GLenum nParam, GLfixed nValue);
void glLightModelfv(GLenum nParam, const GLfloat* nValues);
void glLightModelxv(GLenum nParam, const GLfixed* nValues);
void glShadeModel(GLenum nModel);

void glMaterialf(GLenum nSide, GLenum nSelect, GLfloat nValue);
void glMaterialx(GLenum nSide, GLenum nSelect, GLfixed nValue);
void glMaterialfv(GLenum nSide, GLenum nSelect, const GLfloat* nValues);
void glMaterialiv(GLenum nSide, GLenum nSelect, const GLint* nValues);
void glMaterialxv(GLenum nSide, GLenum nSelect, const GLfixed* nValues);
void glColorMaterial(GLenum nSide, GLenum nMode);
void glGetMaterialfv(GLenum nSide, GLenum nSelect, GLfloat* nValues);
void glGetMaterialiv(GLenum nSide, GLenum nSelect, GLint* nValues);
void glGetMaterialxv(GLenum nSide, GLenum nSelect, GLfixed* nValues);

void glTexParameteri(GLenum nTarget, GLenum nPName, GLint nParam);
void glTexParameterf(GLenum nTarget, GLenum nPName, GLfloat nParam);
void glTexEnvf(GLenum target, GLenum pname, GLfloat param);
void glTexEnvfv(GLenum target, GLenum pname, const GLfloat *params);
void glTexGenf(GLenum coord, GLenum pname, GLfloat param);
void glTexGeni(GLenum coord, GLenum pname, GLint param);
void glTexGenfv(GLenum coord, GLenum pname, const GLfloat *params);
void glAccum(GLenum nOp, GLfloat nValue);
void glPushAttrib(GLbitfield nMask);
void glPopAttrib();
void glPushClientAttrib(GLbitfield mask);
void glPopClientAttrib();
void glLightf(GLenum nLight, GLenum nParamName, GLfloat nParam);
void glLightx(GLenum nLight, GLenum nParamName, GLfixed nParam);
void glPointSize(GLfloat nSize);
void glLineWidth(GLfloat nWidth);
void glLineStipple(GLint factor, GLushort pattern);
void glPolygonStipple(const GLubyte *mask);
void glRasterPos3f(GLfloat x, GLfloat y, GLfloat z);
void glPixelStorei(GLenum pname, GLint param);
void glReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
void glBitmap(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap);
void glListBase(GLuint base);
GLboolean glIsList(GLuint list);
void glCallLists(GLsizei n, GLenum type, const GLvoid *lists);
void glClearIndex(GLfloat c);
void glIndexi(GLint c);
void glViewport(GLint x, GLint y, GLsizei width, GLsizei height);
void glClipPlane(GLenum plane, const GLdouble *equation);
GLuint glGenLists(GLsizei range);
void glDeleteLists(GLuint list, GLsizei range);
void glNewList(GLuint list, GLenum mode);
void glEndList();
void glCallList(GLuint list);
void glAlphaFunc(GLenum func, GLclampf ref);
void glDrawPixels(GLsizei nWidth, GLsizei nHeight, GLenum nFormat, GLenum nType, const GLvoid *nPixels);
void glReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);

void glBegin(GLenum nType);
void glEnd();
void glColor3f(GLfloat nR, GLfloat nG, GLfloat nB);
void glColor3fv(const GLfloat *nV);
void glColor3i(GLint nR, GLint nG, GLint nB);
void glColor3iv(GLint* nV);
void glColor3ub(GLubyte nR, GLubyte nG, GLubyte nB);
void glColor3ubv(const GLubyte *nV);
void glColor3x(GLfixed nR, GLfixed nG, GLfixed nB);
void glColor3xv(const GLfixed *nV);
void glColor4f(GLfloat nR, GLfloat nG, GLfloat nB, GLfloat nA);
void glColor4fv(const GLfloat *nV);
void glColor4i(GLint nR, GLint nG, GLint nB, GLint nA);
void glColor4iv(const GLint* nV);
void glColor4ub(GLubyte nR, GLubyte nG, GLubyte nB, GLubyte nA);
void glColor4ubv(const GLubyte *nV);
void glColor4x(GLfixed nR, GLfixed nG, GLfixed nB, GLfixed nA);
void glColor4xv(const GLfixed *nV);
void glNormal3f(GLfloat nX, GLfloat nY, GLfloat nZ);
void glNormal3fv(const GLfloat *nV);
void glNormal3d(GLdouble nX, GLdouble nY, GLdouble nZ);
void glNormal3dv(const GLdouble *nV);
void glNormal3x(GLfixed nX, GLfixed nY, GLfixed nZ);
void glNormal3xv(const GLfixed *nV);
void glTexCoord2f(GLfloat nX, GLfloat nY);
void glTexCoord2fv(const GLfloat *nV);
void glTexCoord3f(GLfloat nX, GLfloat nY, GLfloat nZ);
void glTexCoord3fv(const GLfloat *nV);
void glTexCoord4f(GLfloat nX, GLfloat nY, GLfloat nZ, GLfloat nW);
void glTexCoord4fv(const GLfloat *nV);
void glTexCoord2d(GLdouble nX, GLdouble nY);
void glTexCoord2dv(const GLdouble *nV);
void glTexCoord3d(GLdouble nX, GLdouble nY, GLdouble nZ);
void glTexCoord3dv(const GLdouble *nV);
void glTexCoord4d(GLdouble nX, GLdouble nY, GLdouble nZ, GLdouble nW);
void glTexCoord4dv(const GLdouble *nV);
void glTexCoord2x(GLfixed nX, GLfixed nY);
void glTexCoord2xv(const GLfixed *nV);
void glTexCoord3x(GLfixed nX, GLfixed nY, GLfixed nZ);
void glTexCoord3xv(const GLfixed *nV);
void glTexCoord4x(GLfixed nX, GLfixed nY, GLfixed nZ, GLfixed nW);
void glTexCoord4xv(const GLfixed *nV);
void glVertex2s(GLshort x, GLshort y);
void glVertex2f(GLfloat x, GLfloat y);
void glVertex3x(GLfixed nX, GLfixed nY, GLfixed nZ);
void glVertex3f(GLfloat nX, GLfloat nY, GLfloat nZ);
void glVertex3fv(const GLfloat *nVertex);
void glVertex3d(GLdouble nX, GLdouble nY, GLdouble nZ);
void glVertex4fv(const GLfloat *nVertex);

void glGenTextures(GLsizei n, GLuint *textures);
void glDeleteTextures(GLsizei n, const GLuint *textures);
void glBindTexture(GLenum nTarget, GLuint nTexture);
void glGetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint *params);
void glTexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height,
				  GLint border, GLenum format, GLenum type, const GLvoid *pixels);


// kl methods
void klCreateDefaultContext();
void klSetBufferSize(int nWidth, int nHeight);
void klSetColorBuffer(void* nMem);
void* klGetColorBuffer();
void klTweak(GLenum nSelect, GLboolean nEnable);

void klPrepareVertexArrays(int nNumVertices, int nNumNormals, int nNumColors, int nNumTexCoords,
							void* nVertices, void* nColors, void* nTexCoords);
void klRenderPreparedIndexedArray(GLenum nPrimType, GLsizei nCount,
								  const unsigned int* nVertexIndices, const unsigned int* nColorIndices, const unsigned int* nTexCoordsIndices,
								  const void* nVertices, const void* nColors, const void* nTexCoords);


// wgl is only supported under windows...
//
#ifdef _IS_WINDOWS_
#include "../wgl_definitions.h"

// wgl methods with _kl postfix
HGLRC wglCreateContext_kl(HDC hdc);
BOOL wglDeleteContext_kl(HGLRC hglrc);
BOOL wglMakeCurrent_kl(HDC hdc, HGLRC hglrc);
HGLRC wglGetCurrentContext_kl();
BOOL SwapBuffers_kl(HDC hdc);
void* wglGetProcAddress_kl(LPCSTR lpszProc);
HDC wglGetCurrentDC_kl();

// some definitions to rename our wgl functions
// to the standard names
#define wglCreateContext wglCreateContext_kl
#define wglDeleteContext wglDeleteContext_kl
#define wglMakeCurrent wglMakeCurrent_kl
#define wglGetCurrentContext wglGetCurrentContext_kl
#define SwapBuffers SwapBuffers_kl
#define wglGetProcAddress wglGetProcAddress_kl
#define wglGetCurrentDC wglGetCurrentDC_kl
#endif //_IS_WINDOWS_


// egl methods
//
EGLDisplay eglGetDisplay(NativeDisplayType nDisplay);
EGLBoolean eglInitialize(EGLDisplay dpy, EGLint *major, EGLint *minor);
EGLSurface eglCreateWindowSurface(EGLDisplay dpy, EGLConfig config, NativeWindowType window, const EGLint *attrib_list);
EGLBoolean eglDestroySurface(EGLDisplay dpy, EGLSurface surface);
EGLContext eglCreateContext(EGLDisplay dpy, EGLConfig config, EGLContext share_list, const EGLint *attrib_list);
EGLBoolean eglDestroyContext(EGLDisplay dpy, EGLContext ctx);
EGLBoolean eglMakeCurrent(EGLDisplay dpy, EGLSurface draw, EGLSurface read, EGLContext ctx);
EGLContext eglGetCurrentContext(void);
EGLSurface eglGetCurrentSurface (EGLint readdraw);
EGLDisplay eglGetCurrentDisplay(void);
EGLBoolean eglWaitGL(void);
EGLBoolean eglWaitNative (EGLint engine);
EGLBoolean eglSwapBuffers(EGLDisplay dpy, EGLSurface draw);

#ifdef __cplusplus
}
#endif


#endif //__GL_HEADERFILE__
