/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/Base/klFixedBase_gpp.h,v 1.2 2004/02/06 14:15:10 drgoldie Exp $
 *
\**************************************************************************/


#ifndef __KLFIXEDBASE_GPP_HEADERFILE__
#define __KLFIXEDBASE_GPP_HEADERFILE__


// MATHBASE implementation for klFloat_fixed
// that provides XScale optimized routines by
// using the Intel GPP.
// Currently this only works on PocketPCs.
//
// If you do not want to use GPP please remove
// the _USE_FIXED_GPP_ setting from the
// preprocessor definitions in the project settings.
//
#include <gpp.h>

#ifdef DEBUG
  //#pragma comment( lib, "gpp_XSC11_d.lib" )
  #pragma comment( lib, "gpp_WMMX40B_d.lib" )
#else
  //#pragma comment( lib, "gpp_XSC11_r.lib" )
  #pragma comment( lib, "gpp_WMMX40B_r.lib" )
#endif //DEBUG


class klFixedBase_gpp
{
public:
	enum {
		PBITS = 16
	};

	static float floatFromFixed(int nFixed)
	{
		return nFixed/(float)(1 << PBITS);
	}

	static double doubleFromFixed(int nFixed)
	{
		return nFixed/(double)(1 << PBITS);
	}

	static int fixedFromInt(int nV)
	{
		return nV<<PBITS;
	}

	static int fixedFromFloat(float nV)
	{
		return (int)(nV *  (float)(1 << PBITS) + 0.5f);
	}

	static int fixedFromDouble(double nV)
	{
		return (int)(nV * (double)(1 << PBITS) + 0.5f);
	}

	static int inverse(int nFixed)
	{
		int ret=0;
		gppInvHP_16_32s(nFixed, &ret);
		return ret;
	}

	static int multiply(int nLeftFixed, int nRightFixed)
	{
		int ret;
		gppMul_16_32s(nLeftFixed, nRightFixed, &ret);
		return ret;
	}

	static int divide(int nLeftFixed, int nRightFixed)
	{
		int ret;
		gppDiv_16_32s(nLeftFixed, nRightFixed, &ret);
		return ret;
	}

	static int cos(int nFixed)
	{
		int ret;
		gppCosHP_16_32s(nFixed, &ret);
		return ret;
	}

	static int sin(int nFixed)
	{
		int ret;
		gppSinHP_16_32s(nFixed, &ret);
		return ret;
	}

	static int fabs(int nFixed)
	{
		return nFixed<0 ? -nFixed : nFixed;
	}

	static int sqrt(int nFixed)
	{
		unsigned int ret;
		gppSqrtHP_16_32s(nFixed, &ret);
		return (int)ret;
	}

	static int inverseSqrt(int nFixed)
	{
		unsigned int ret;
		gppInvSqrtHP_16_32s(nFixed, &ret);
		return (int)ret;
	}

	static int ceil(int nFixed)
	{
		int ret = (nFixed>>PBITS)<<PBITS;

		if(nFixed>=0 && ret<nFixed)
			ret += fixedFromInt(1);

		return ret;
	}
};


#endif //__KLFIXEDBASE_GPP_HEADERFILE__
