/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/Base/klVertex.h,v 1.2 2004/02/06 14:15:10 drgoldie Exp $
 *
\**************************************************************************/


#ifndef __KLVERTEX_HEADERFILE__
#define __KLVERTEX_HEADERFILE__


// klVertex stores vertex data as needed
// inside the opengl state.
//
struct klVertex
{
	klVec4 pos;				// 3D position (in all states: raw, transformed & projected)
	klFloat unprojectedZ;	// stores the unprojected z-value which we need for texturing...
	klColor4 col;			// color as RGBA
	klVec4 texCoord;		// texture coordinate
	klFloat fogDensity;		// fog density value (0.0-1.0)


	// does linear interpolation position, color & texture coordinate between two vertices.
	//
	inline void interpolateInclColor(const klVertex& nLeft, const klVertex& nRight, const klFloat& nFactor);
};


inline void
klVertex::interpolateInclColor(const klVertex& nV0, const klVertex& nV1, const klFloat& nF)
{
	pos.interpolate(nV0.pos,nV1.pos, nF);

	//
	// TODO: this should both be conditional
	//
	col.interpolate(nV0.col,nV1.col, nF);
	texCoord.interpolate(nV0.texCoord,nV1.texCoord, nF);
}


#endif //__KLVERTEX_HEADERFILE__
