#ifndef USE_C

 .data
 storage:
 .string	"0123012301230123012301230123012301230123"
 storage2:
 .string	"01230123012301230123"

 .text
 .align
 .global flipNormal    				// rotating blit 
 .global flipLandscape1 			// straight memcpy blit
 .global flipLandscape2				// mirrored blit
 
 
//----------------------------------------------------------------------------
/*
*
*	Full screen blit for rotated mode 
*	void flipNormal(void *dst, void *src);       
*	average 7.5 ms  full screen
*/
//----------------------------------------------------------------------------

flipNormal:
	stmdb   sp!, { r0 - r12, lr }
	
	
	
	ldr	r3,=storage
	str	r13,[r3]

	ldr	r13,=80				// r2, r13, r14,r4
	add	r0,r0,#640-8
	

	ldr	r3,=120
	mov	r12,r0	
	ldr	r5,=0x0000FFFF			// first mask
	mov	r6,r1
	
flipNormal_main_loop:
	
	
	ldr	r8,[r1]
	ldr	r7,[r1,#240*2]			// r7=r2, r8=r1
              
	
	and	r9,r7,r5			// r9 has  left part of bottom	
	and	r10,r8,r5			// r10 has left part of top	
	orr	r4,r9,r10,asl #16   	
	

	and 	r9,r7,r5,lsl #16 		// r9 has right part of the bottom
	and	r10,r8,r5,lsl #16		// r10 has right part of the top
	orr	r14,r10,r9,lsr #16

	ldr	r8,[r1,#240*4]
	ldr	r7,[r1,#240*6]			// r7=r2, r8=r1         
	add	r1,r1,#4
	
	and	r9,r7,r5			// r9 has  left part of bottom	
	and	r10,r8,r5			// r10 has left part of top	
	orr	r2,r9,r10,asl #16   
	
	and 	r9,r7,r5,lsl #16 		// r9 has right part of the bottom
	and	r10,r8,r5,lsl #16		// r10 has right part of the top
	orr	r10,r10,r9,lsr #16

	stmia	r0!,{r2,r4}
	add	r0,r0,#640-8
	stmia	r0!,{r10,r14} 
	add	r0,r0,#640-8
				
	subs	r3,r3,#1
	bne	flipNormal_main_loop		// horizontal loop 
      	
	add	r6,r6,#240*8  
	mov	r1,r6
		
	subs	r12,r12,#8
	mov	r0,r12		
	ldr	r3,=120		
	
	subs	r13,r13,#1	
	bne	flipNormal_main_loop		// vertical loop
  

	ldr	r3,=storage
	ldr	r13,[r3]


        ldmia   sp!, { r0 - r12, pc }


// 	r0=dest
//	r1=source


//----------------------------------------------------------------------------
/*
*
*	Full screen blit for mirrored mode
*	void flipLandscape2(void *dst, void *src);       
*	average: 6.1 ms full screen blit
*/
//----------------------------------------------------------------------------

flipLandscape2:
	stmdb   sp!, { r0 - r12, lr }
	
	ldr	r3,=storage
	str	r13,[r3]

	ldr	r2,=0x25800		
	add	r14,r1,r2		// r14 contains points to the addres right after memory buffer (320x240x2)
	
	mov	r12,r1			// r12 contains source
	add	r13,r0,r2		// r13 contains destination
	sub	r13,r13,#4
	
flipLandscape2_main_loop:	
	ldmia	r12!,{r0-r9}
	
	mov	r10,r0,lsl #16
	orr	r0,r10,r0, lsr #16			
	str	r0,[r13],#-4

	mov	r10,r1,lsl #16
	orr	r1,r10,r1, lsr #16		
	str	r1,[r13],#-4
	
	mov	r10,r2,lsl #16
	orr	r2,r10,r2, lsr #16
	str	r2,[r13],#-4
	
	mov	r10,r3,lsl #16
	orr	r3,r10,r3, lsr #16
	str	r3,[r13],#-4
	
	mov	r10,r4,lsl #16
	orr	r4,r10,r4, lsr #16
	str	r4,[r13],#-4
	
	mov	r10,r5,lsl #16
	orr	r5,r10,r5, lsr #16
	str	r5,[r13],#-4
	
	mov	r10,r6,lsl #16
	orr	r6,r10,r6, lsr #16
	str	r6,[r13],#-4
	
	mov	r10,r7,lsl #16
	orr	r7,r10,r7, lsr #16
	str	r7,[r13],#-4
	
	mov	r10,r8,lsl #16
	orr	r8,r10,r8, lsr #16
	str	r8,[r13],#-4
	
	mov	r10,r9,lsl #16
	orr	r9,r10,r9, lsr #16
	str	r9,[r13],#-4	
  

	cmp	r12,r14
	blo	flipLandscape2_main_loop


	ldr	r3,=storage
	ldr	r13,[r3]

        ldmia   sp!, { r0 - r12, pc }


//----------------------------------------------------------------------------
/*
*
*	Full screen blit for unrotated 320x240x16 mode
*	void flipLandscape1(void *dst, void *src);       
*       average: 5.5  ms full screen blit
*/
//----------------------------------------------------------------------------


flipLandscape1:
	stmdb   sp!, { r0 - r12, lr }
	
	ldr	r3,=storage
	str	r13,[r3]
	
	ldr	r2,=0x25800
	add	r14,r1,r2	
	
	mov	r12,r1			
	mov	r13,r0			

flipLandscape1_main_loop:	
	ldmia	r12!,{r0-r11}
	stmia	r13!,{r0-r11}
	ldmia	r12!,{r0-r11}
	stmia	r13!,{r0-r11}	
	ldmia	r12!,{r0-r11}
	stmia	r13!,{r0-r11}
	ldmia	r12!,{r0-r11}
	stmia	r13!,{r0-r11}	
	cmp	r12,r14
	blo	flipLandscape1_main_loop

	ldr	r3,=storage
	ldr	r13,[r3]

        ldmia   sp!, { r0 - r12, pc }

#endif
