#include "ZFont.h"    
#include <qfontmetrics.h>



ZFont::ZFont():ZSurface()
{
   initGeneric();   
}


ZFont::ZFont(const QImage &img, QColor c):ZSurface(img)
{
   initGeneric();
   initFromCustomImage(c);
}

ZFont::ZFont(const QPixmap &pix, QColor c):ZSurface(pix)
{
   initGeneric();
   initFromCustomImage(c);
}

ZFont::ZFont(const QFont &f, QColor foreCol,  QColor backCol):ZSurface()
{
   initGeneric();
   initFromCustomFont(f,foreCol,backCol);   
}

ZFont::~ZFont()
{
   
}

ZFont & ZFont::operator=(const ZFont &f)
{
   if ( this!=&f )
   {
      copyFont(f);         
   }
   return *this;   
}

ZFont::ZFont(const ZFont &f):ZSurface((ZSurface&)f)
{
   copyFont(f);   
}

void ZFont::copyFont(const ZFont &f)
{
   memcpy(iOffset,f.iOffset,(256-32)*sizeof(int));
   memcpy(iWidth,f.iWidth,(256-32)*sizeof(int));
   iHeight=f.iHeight;
   skipTop=f.skipTop;
   iSpacing=f.iSpacing;
   iBackColor=f.iBackColor;
}

bool ZFont::create(const QImage &i, QColor c)
{
   if ( ZSurface::create(i) )
   {
      initGeneric();
      initFromCustomImage(c);
      return true;
   }
   return false;
}

bool ZFont::create(const QPixmap &p, QColor c)
{
   if ( ZSurface::create(p) )
   {
      initGeneric();
      initFromCustomImage(c);
      return true;
   }
   return false;
}

bool ZFont::create(const QFont &f, QColor foreCol, QColor backCol)
{
   initGeneric();
   return initFromCustomFont(f,foreCol,backCol);
   
}

void ZFont::initGeneric()
{
   skipTop=1;
   iSpacing=1;

   for ( int i=0;i<256-32;i++ )  // clear everything - start with space
   {
      iOffset[i]=0;
      iWidth[i]=0;
      iHeight=height()-1;
   }
}

bool ZFont::initFromCustomFont(const QFont &f, QColor foreCol,  QColor backCol)
{
   QFontMetrics fm(f);
   iBackColor=backCol;
   int nextPos=0;
   QRect br;
   for ( int i=0;i<127-32;i++ )
   {
      iOffset[i]=nextPos;      
      br=fm.boundingRect(i+32);
      iWidth[i]=br.width();
      nextPos+=iWidth[i];
   }

   QPixmap tmp(nextPos,fm.height());
   tmp.fill(backCol);
   QPainter p(&tmp);
   p.setFont(f);
   p.setPen(foreCol);
   for ( int i=0;i<127-32;i++ )
   {
      p.drawText(iOffset[i],0,iWidth[i],tmp.height(),0,QString(QChar((char)(i+32))));
   }   
   iHeight=tmp.height();
   skipTop=0;
   iSpacing=0;

   return ZSurface::create(tmp);
}



void ZFont::initFromCustomImage(QColor c)
{
   int i;
   // walk the image and update font sizes

   iBackColor=c;
   int   currFont=0;
   bool  inside=false;
   QColor   pixCol;

   for ( i=0;i<width();i++ )
   {
      getPixel(i,0,pixCol);      
      if ( pixCol.red()==248 && pixCol.green()==252 && pixCol.blue()==248 )
      {
         if ( !inside )
         {
            inside=true;
            iOffset[currFont]=i;
         }
      }
      else if ( inside )
      {
         inside=false;
         iWidth[currFont]=i-iOffset[currFont];
         currFont++;
      }
   }
}

int  ZFont::stringWidth(const QString &s) const
{
   int len=0;

   const char *text=s.latin1();

   for ( int i=0;i<s.length();i++ )
   {
      len+=(iWidth[(int)(text[i]-32)])+iSpacing;
   }

   return len;   
}

