/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/RasterizerSW565/klRSW565_InterpolatorRGBA.h,v 1.2 2004/02/10 18:19:31 drgoldie Exp $
 *
\**************************************************************************/


//
//class klRSW565 {
//


class InterpolatorRGBA_Linear
{
public:
	//typedef float			DTYPE;
	typedef int 	DTYPE;

	enum {
		PBITS = 12,
		PFACT = 1<<PBITS,
		ROUNDVAL = PFACT>>1,
	};

	InterpolatorRGBA_Linear(int nR0, int nG0, int nB0, int nA0, int nR1, int nG1, int nB1, int nA1, int nLength)
	{
		set(nR0,nG0,nB0,nA0, nR1,nG1,nB1,nA1, nLength);
	}

	InterpolatorRGBA_Linear(const Edge* nLeft, const Edge* nRight, int nLength)
	{
		set(nLeft->R.getInt(),nLeft->G.getInt(),nLeft->B.getInt(),nLeft->A.getInt(),
			nRight->R.getInt(),nRight->G.getInt(),nRight->B.getInt(),nRight->A.getInt(),
			nLength);
	}

	InterpolatorRGBA_Linear(const Edge* nLeft, const Edge* nRight, const klFloat& nInvLength)
	{
		set(nLeft->R.getInt(),nLeft->G.getInt(),nLeft->B.getInt(),nLeft->A.getInt(),
			nRight->R.getInt(),nRight->G.getInt(),nRight->B.getInt(),nRight->A.getInt(),
			nInvLength);
	}

	void step()
	{
		r += dr;
		g += dg;
		b += db;
		a += da;
	}

	void step(int nSteps)
	{
		r += nSteps*dr;
		g += nSteps*dg;
		b += nSteps*db;
		a += nSteps*da;
	}

	DTYPE getR()
	{
		return (r+ROUNDVAL)>>PBITS;
	}

	DTYPE getG()
	{
		return (g+ROUNDVAL)>>PBITS;
	}

	DTYPE getB()
	{
		return (b+ROUNDVAL)>>PBITS;
	}

	DTYPE getA()
	{
		return (a+ROUNDVAL)>>PBITS;
	}

	unsigned int getRGB565()	// this works only for PBITS=12 !!!
	{
		return ((r>>4)&RED_MASK) | ((g>>9)&GREEN_MASK) | ((b>>15)&BLUE_MASK);
	}

	unsigned int getARGB8565()	// this works only for PBITS=12 !!!
	{
		return	((a<<4)&0x00FF0000) | ((r>>4)&RED_MASK) | ((g>>9)&GREEN_MASK) | ((b>>15)&BLUE_MASK);
	}

	unsigned int getRGB888()	// this works only for PBITS=12 !!!
	{
		return ((r<<4)&0x00ff0000) | ((g>>4)&0x0000ff00) | ((b>>12)&0x000000ff);
	}

protected:
	void set(int nR0, int nG0, int nB0, int nA0, int nR1, int nG1, int nB1, int nA1, int nLength)
	{
		r = (DTYPE)(nR0<<PBITS);
		g = (DTYPE)(nG0<<PBITS);
		b = (DTYPE)(nB0<<PBITS);
		a = (DTYPE)(nA0<<PBITS);

		if(nLength<1)
			return;

		int invLen = (PFACT*PFACT) / (nLength);

		dr = (DTYPE)(((nR1-nR0)*invLen)>>(PBITS));
		dg = (DTYPE)(((nG1-nG0)*invLen)>>(PBITS));
		db = (DTYPE)(((nB1-nB0)*invLen)>>(PBITS));
		da = (DTYPE)(((nA1-nA0)*invLen)>>(PBITS));
	}

	void set(int nR0, int nG0, int nB0, int nA0, int nR1, int nG1, int nB1, int nA1, klFloat nInvLength)
	{
		r = (DTYPE)(nR0<<PBITS);
		g = (DTYPE)(nG0<<PBITS);
		b = (DTYPE)(nB0<<PBITS);
		a = (DTYPE)(nA0<<PBITS);

		int invLen = nInvLength.getFixed() << 8;	// shift 2*4 bits since klFloat uses 16 precision bits instead of 12...

		dr = (DTYPE)(((nR1-nR0)*invLen)>>(PBITS));
		dg = (DTYPE)(((nG1-nG0)*invLen)>>(PBITS));
		db = (DTYPE)(((nB1-nB0)*invLen)>>(PBITS));
		da = (DTYPE)(((nA1-nA0)*invLen)>>(PBITS));
	}

	DTYPE	r,g,b,a,
			dr,dg,db,da;
};

//
// } class klRSW565
//
