/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Id: klEGLSurfacePocketHAL.cpp,v 1.1 2004/01/13 11:20:10 drgoldie Exp $
 *
\**************************************************************************/


#ifdef _USE_POCKETHAL_


#include "klEGLSurfacePocketHAL.h"


PHAL::Display*	klEGLSurfacePocketHAL::phDisplay = NULL;
bool			klEGLSurfacePocketHAL::phDisplayInitialized = false;

//
// if you do not want to use PocketHAL please
// remove the _USE_POCKETHAL_ setting from the
// preprocessor definitions in the project settings.
//
#include <PocketHal/display.h>
#include <PocketHal/surface.h>
#pragma comment( lib, "PocketHAL_ARM.lib" )


klEGLSurfacePocketHAL::klEGLSurfacePocketHAL()
{
	colorType = COLOR_TYPE_RGB565;
	depthType = DEPTH_TYPE_INT32;

	width = height = 0;
	cBuffer = NULL;
	zBuffer = NULL;
}


klEGLSurfacePocketHAL::~klEGLSurfacePocketHAL()
{
	destroy();
}


bool
klEGLSurfacePocketHAL::setNativeWindow(NativeWindowType nWnd)
{
	hwnd = nWnd;									// note: we keep this HWND and HDC

	//
	// TODO: also support non fullscreen windows
	//

	// try to call up PocketHAL
	//
	PHAL::DisplayParameters		phDisplayParams;
	phDisplayParams.m_orientation = PHAL::ORIENTATION_PORTRAIT;		// use rotated 90 to the left

	if(phDisplay==NULL)
		phDisplay = PHAL::Display::Create();
	phDisplayInitialized = true;

	if(!phDisplay->Initialize(hwnd, phDisplayParams))
		return false;

	cBuffer = (unsigned short*)phDisplay->GetBackBuffer()->GetPixels();

	setSize(320,240);

	return true;
}


bool
klEGLSurfacePocketHAL::setNativeDisplay(NativeDisplayType nDisp)
{
	// this will work as long as there is only one window
	// in this application
	hdc = nDisp;
	hwnd = GetActiveWindow();

	if(hwnd==NULL)
		return false;

	return setNativeWindow(hwnd);
}


NativeWindowType
klEGLSurfacePocketHAL::getNativeWindow()
{
	return hwnd;
}


NativeDisplayType
klEGLSurfacePocketHAL::getNativeDisplay()
{
	return hdc;
}


bool
klEGLSurfacePocketHAL::destroy()
{
	bool ret = true;

	if(zBuffer)
		delete zBuffer;
	zBuffer = NULL;

	width = height = 0;

	if(phDisplay && phDisplayInitialized)
	{
		phDisplay->Shutdown();
		delete phDisplay;
		phDisplay = NULL;
		cBuffer = NULL;
		phDisplayInitialized = false;
		Sleep(200);
	}

	return ret;
}


void
klEGLSurfacePocketHAL::setSize(int nWidth, int nHeight)
{
	if(width!=nWidth || height!=nHeight)
	{
		width = nWidth;
		height = nHeight;

		if(zBuffer)
			delete zBuffer;
		zBuffer = new unsigned int[width*height];
	}
}


bool
klEGLSurfacePocketHAL::flip()
{
	if(phDisplay)
	{
		phDisplay->Swap();
		cBuffer = (unsigned short*)phDisplay->GetBackBuffer()->GetPixels();
	}

	return true;
}


#endif //_USE_POCKETHAL_
