/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * Copies the video backbuffer onto the device's display
 * (used under windows ce only). Uses macro blocks to good
 * cache usage (this is multiple times faster than rotating
 * the whole image at once...)
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/klBlitter.h,v 1.2 2004/01/13 14:40:27 tuhtah Exp $
 *
\**************************************************************************/



#ifndef __KLBLITTER_HEADERFILE__
#define __KLBLITTER_HEADERFILE__

namespace klBlitter
{
	enum ROTATION
	{
		ROTATE_0 = 0,
		ROTATE_90 = 1,
		ROTATE_180 = 2,
		ROTATE_270 = 3
	};

	void blit(unsigned short* nDst, const unsigned short* nSrc,
			  int nSrcW, int nSrcH, ROTATION nRot,
			  int nDstW, int nDstH,
			  int nBlockW, int nBlockH);
}


#endif //__KLBLITTER_HEADERFILE__
