/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/klContext_Internal.h,v 1.2 2004/02/06 14:14:53 drgoldie Exp $
 *
\**************************************************************************/



void
klContext::LIGHTINGCACHE::updateModelAmbient(const klContext::MATERIAL& nMaterial,
											 const klContext::LIGHTMODEL& nLightModel)
{
	modelAmbient[nMaterial.idx].multiplyComonentWise(nMaterial.ambient, nLightModel.ambient);
	modelAmbient[nMaterial.idx] += nMaterial.emissive;
}


void
klContext::LIGHTINGCACHE::updateLightAmbient(const klContext::MATERIAL& nMaterial,
											 const klContext::LIGHT& nLight)
{
	lightAmbient[nLight.idx][nMaterial.idx].multiplyComonentWise(nMaterial.ambient, nLight.ambient);
}


void
klContext::LIGHTINGCACHE::updateLightAmbient(const klContext::MATERIAL& nMaterial,
											 const klContext::LIGHT* nLights)
{
	for(int i=0; i<MAX_LIGHTS; i++)
		lightAmbient[i][nMaterial.idx].multiplyComonentWise(nMaterial.ambient, nLights[i].ambient);
}


void
klContext::LIGHTINGCACHE::updateLightDiffuse(const klContext::MATERIAL& nMaterial,
											 const klContext::LIGHT& nLight)
{
	lightDiffuse[nLight.idx][nMaterial.idx].multiplyComonentWise(nMaterial.diffuse, nLight.diffuse);
}


void
klContext::LIGHTINGCACHE::updateLightDiffuse(const klContext::MATERIAL& nMaterial,
											 const klContext::LIGHT* nLights)
{
	for(int i=0; i<MAX_LIGHTS; i++)
		lightDiffuse[i][nMaterial.idx].multiplyComonentWise(nMaterial.diffuse, nLights[i].diffuse);
}


void
klContext::LIGHTINGCACHE::updateLightSpecular(const klContext::MATERIAL& nMaterial,
											  const klContext::LIGHT& nLight)
{
	lightSpecular[nLight.idx][nMaterial.idx].multiplyComonentWise(nMaterial.specular, nLight.specular);
}


void
klContext::LIGHTINGCACHE::updateLightSpecular(const klContext::MATERIAL& nMaterial,
											  const klContext::LIGHT* nLights)
{
	for(int i=0; i<MAX_LIGHTS; i++)
		lightSpecular[i][nMaterial.idx].multiplyComonentWise(nMaterial.specular, nLights[i].specular);
}
