/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/klContext_oglBeginEnd.h,v 1.3 2004/01/27 08:17:50 drgoldie Exp $
 *
\**************************************************************************/



/**
class klContext
{
*/


//
// This file holds all opengl functions that deal with the
//
//                 glBegin/glEnd pragma
//

void glBegin(GLenum nType)
{
	RECORD_DISPLAYLISTS1(Begin, nType)
	if(!displaylist.executeCommands)
		return;

	beginendState.primType = nType;
	beginendState.numVertices = 0;

	checkModelProjMatrix();
	configureRasterizer();
}


void glEnd()
{
	RECORD_DISPLAYLISTS0(End)
	if(!displaylist.executeCommands)
		return;

	switch(beginendState.primType)
	{
	case GL_TRIANGLES:
	case GL_QUADS:
		// these types are rendered when glVertex() is called
		break;

	case GL_LINE_LOOP:
	case GL_LINE_STRIP:
	case GL_TRIANGLE_FAN:
	case GL_QUAD_STRIP:
	case GL_TRIANGLE_STRIP:
	case GL_POLYGON:
		renderBeginEndPrimitive();
		break;
	}

	beginendState.primType = GL_NONE;
	beginendState.numVertices = 0;
}


void glColor3f(GLfloat nR, GLfloat nG, GLfloat nB)
{
	klColor4 col(nR, nG, nB, 1.0f);

	RECORD_DISPLAYLISTS1(Color, col)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentColor = col;
	updateColorMaterial();
}


void glColor3fv(const GLfloat *nV)
{
	klColor4 col(nV[0], nV[1], nV[2], 1.0f);

	RECORD_DISPLAYLISTS1(Color, col)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentColor = col;
	updateColorMaterial();
}


void glColor3i(GLint nR, GLint nG, GLint nB)
{
	klColor4 col;
	col.setFixed(nR>>16, nG>>16, nB>>16, 1<<16);

	RECORD_DISPLAYLISTS1(Color, col)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentColor = col;
	updateColorMaterial();
}


void glColor3iv(const GLint* nV)
{
	klColor4 col;
	col.setFixed(nV[0]>>16, nV[1]>>16, nV[2]>>16, 1<<16);

	RECORD_DISPLAYLISTS1(Color, col)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentColor = col;
	updateColorMaterial();
}


void glColor3ub(GLubyte nR, GLubyte nG, GLubyte nB)
{
	klColor4 col;
	col.setFixed(nR<<8, nG<<8, nB<<8, 1<<16);

	RECORD_DISPLAYLISTS1(Color, col)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentColor = col;
	updateColorMaterial();
}


void glColor3ubv(const GLubyte *nV)
{
	klColor4 col;
	col.setFixed(nV[0]<<8, nV[1]<<8, nV[2]<<8, 1<<16);

	RECORD_DISPLAYLISTS1(Color, col)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentColor = col;
	updateColorMaterial();
}


void glColor3x(GLfixed nR, GLfixed nG, GLfixed nB)
{
	klColor4 col;
	col.setFixed(nR, nG, nB, 1<<16);

	RECORD_DISPLAYLISTS1(Color, col)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentColor = col;
	updateColorMaterial();
}


void glColor3xv(const GLfixed *nV)
{
	klColor4 col;
	col.setFixed(nV[0], nV[1], nV[2], 1<<16);

	RECORD_DISPLAYLISTS1(Color, col)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentColor = col;
	updateColorMaterial();
}


void glColor4f(GLfloat nR, GLfloat nG, GLfloat nB, GLfloat nA)
{
	klColor4 col;
	col.setFloat(nR, nG, nB, nA);

	RECORD_DISPLAYLISTS1(Color, col)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentColor = col;
	updateColorMaterial();
}


void glColor4fv(const GLfloat *nV)
{
	klColor4 col;
	col.setFloat(nV);

	RECORD_DISPLAYLISTS1(Color, col)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentColor = col;
	updateColorMaterial();
}


void glColor4i(GLint nR, GLint nG, GLint nB, GLint nA)
{
	klColor4 col;
	col.setFixed(nR>>16, nG>>16, nB>>16, nA>>16);

	RECORD_DISPLAYLISTS1(Color, col)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentColor = col;
	updateColorMaterial();
}


void glColor4iv(const GLint* nV)
{
	klColor4 col;
	col.setFixed(nV[0]>>16, nV[1]>>16, nV[2]>>16, nV[3]>>16);

	RECORD_DISPLAYLISTS1(Color, col)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentColor = col;
	updateColorMaterial();
}


void glColor4ub(GLubyte nR, GLubyte nG, GLubyte nB, GLubyte nA)
{
	klColor4 col;
	col.setFixed(nR<<8, nG<<8, nB<<8, nA<<8);

	RECORD_DISPLAYLISTS1(Color, col)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentColor = col;
	updateColorMaterial();
}


void glColor4ubv(const GLubyte *nV)
{
	klColor4 col;
	col.setFixed(nV[0]<<8, nV[1]<<8, nV[2]<<8, nV[3]<<8);

	RECORD_DISPLAYLISTS1(Color, col)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentColor = col;
	updateColorMaterial();
}


void glColor4x(GLfixed nR, GLfixed nG, GLfixed nB, GLfixed nA)
{
	klColor4 col;
	col.setFixed(nR, nG, nB, nA);

	RECORD_DISPLAYLISTS1(Color, col)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentColor = col;
	updateColorMaterial();
}


void glColor4xv(const GLfixed *nV)
{
	klColor4 col;
	col.setFixed(nV);

	RECORD_DISPLAYLISTS1(Color, col)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentColor = col;
	updateColorMaterial();
}


void glColor(const klColor4& nColor)
{
	beginendState.currentColor = nColor;
	updateColorMaterial();
}


void glNormal3f(GLfloat nX, GLfloat nY, GLfloat nZ)
{
	klVec3 normal;
	normal.setFloat(nX, nY, nZ);

	if(normalizeNormalsEnabled)
		normal.normalize();

	RECORD_DISPLAYLISTS1(Normal, normal)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentNormal = normal;
}


void glNormal3fv(const GLfloat *nV)
{
	klVec3 normal;
	normal.setFloat(nV);

	if(normalizeNormalsEnabled)
		normal.normalize();

	RECORD_DISPLAYLISTS1(Normal, normal)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentNormal = normal;
}


void glNormal3d(GLdouble nX, GLdouble nY, GLdouble nZ)
{
	klVec3 normal;
	normal.setDouble(nX, nY, nZ);

	if(normalizeNormalsEnabled)
		normal.normalize();

	RECORD_DISPLAYLISTS1(Normal, normal)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentNormal = normal;
}


void glNormal3dv(const GLdouble *nV)
{
	klVec3 normal;
	normal.setDouble(nV);

	if(normalizeNormalsEnabled)
		normal.normalize();

	RECORD_DISPLAYLISTS1(Normal, normal)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentNormal = normal;
}


void glNormal3x(GLfixed nX, GLfixed nY, GLfixed nZ)
{
	klVec3 normal;
	normal.setFixed(nX, nY, nZ);

	if(normalizeNormalsEnabled)
		normal.normalize();

	RECORD_DISPLAYLISTS1(Normal, normal)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentNormal = normal;
}


void glNormal3xv(const GLfixed *nV)
{
	klVec3 normal;
	normal.setFixed(nV);

	if(normalizeNormalsEnabled)
		normal.normalize();

	RECORD_DISPLAYLISTS1(Normal, normal)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentNormal = normal;
}


void glNormal(const klVec3& nNormal)
{
	// we assume that nNormal is already normalized
	//
	beginendState.currentNormal = nNormal;
}


void glTexCoord2f(GLfloat nX, GLfloat nY)
{
	klVec4 texCoord;
	texCoord.setFloat(nX, nY, 0.0f, 1.0f);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord2fv(const GLfloat *nV)
{
	klVec4 texCoord;
	texCoord.setFloat(nV[0], nV[1], 0.0f, 1.0f);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord3f(GLfloat nX, GLfloat nY, GLfloat nZ)
{
	klVec4 texCoord;
	texCoord.setFloat(nX, nY, nZ, 1.0f);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord3fv(const GLfloat *nV)
{
	klVec4 texCoord;
	texCoord.setFloat(nV[0], nV[1], nV[2], 1.0f);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord4f(GLfloat nX, GLfloat nY, GLfloat nZ, GLfloat nW)
{
	klVec4 texCoord;
	texCoord.setFloat(nX, nY, nZ, nW);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord4fv(const GLfloat *nV)
{
	klVec4 texCoord;
	texCoord.setFloat(nV);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord2d(GLdouble nX, GLdouble nY)
{
	klVec4 texCoord;
	texCoord.setDouble(nX, nY, 0.0, 1.0);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord2dv(const GLdouble *nV)
{
	klVec4 texCoord;
	texCoord.setDouble(nV[0], nV[1], 0.0, 1.0);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord3d(GLdouble nX, GLdouble nY, GLdouble nZ)
{
	klVec4 texCoord;
	texCoord.setDouble(nX, nY, nZ, 1.0);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord3dv(const GLdouble *nV)
{
	klVec4 texCoord;
	texCoord.setDouble(nV[0], nV[1], nV[2], 1.0);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord4d(GLdouble nX, GLdouble nY, GLdouble nZ, GLdouble nW)
{
	klVec4 texCoord;
	texCoord.setDouble(nX, nY, nZ, nW);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord4dv(const GLdouble *nV)
{
	klVec4 texCoord;
	texCoord.setDouble(nV);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord2x(GLfixed nX, GLfixed nY)
{
	klVec4 texCoord;
	texCoord.setFixed(nX, nY, 0, 1<<16);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord2xv(const GLfixed *nV)
{
	klVec4 texCoord;
	texCoord.setFixed(nV[0], nV[1], 0, 1<<16);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord3x(GLfixed nX, GLfixed nY, GLfixed nZ)
{
	klVec4 texCoord;
	texCoord.setFixed(nX, nY, nZ, 1<<16);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord3xv(const GLfixed *nV)
{
	klVec4 texCoord;
	texCoord.setFixed(nV[0], nV[1], nV[2], 1<<16);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord4x(GLfixed nX, GLfixed nY, GLfixed nZ, GLfixed nW)
{
	klVec4 texCoord;
	texCoord.setFixed(nX, nY, nZ, nW);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord4xv(const GLfixed *nV)
{
	klVec4 texCoord;
	texCoord.setFixed(nV);

	RECORD_DISPLAYLISTS1(TexCoord, texCoord)
	if(!displaylist.executeCommands)
		return;

	beginendState.currentTexCoord = texCoord;
}


void glTexCoord(const klVec4& nTexCoord)
{
	beginendState.currentTexCoord = nTexCoord;
}


void glVertex2s(GLshort x, GLshort y)
{
	klVec4 vertex;
	vertex.setInt(x,y,0,1);

	RECORD_DISPLAYLISTS1(Vertex, vertex)
	if(!displaylist.executeCommands)
		return;

	beginendState.vertices[beginendState.numVertices] = vertex;
	beginendState.fillVertex();
	checkFinishedPrimitive();
}


void glVertex2f(float x, float y)
{
	klVec4 vertex;
	vertex.setFloat(x,y,0.0f,1.0f);

	RECORD_DISPLAYLISTS1(Vertex, vertex)
	if(!displaylist.executeCommands)
		return;

	beginendState.vertices[beginendState.numVertices] = vertex;
	beginendState.fillVertex();
	checkFinishedPrimitive();
}


void glVertex3x(GLfixed nX, GLfixed nY, GLfixed nZ)
{
	klVec4 vertex;
	vertex.setFixed(nX,nY,nZ,1<<16);

	RECORD_DISPLAYLISTS1(Vertex, vertex)
	if(!displaylist.executeCommands)
		return;

	beginendState.vertices[beginendState.numVertices] = vertex;
	beginendState.fillVertex();
	checkFinishedPrimitive();
}


void glVertex3f(float nX, float nY, float nZ)
{
	klVec4 vertex;
	vertex.setFloat(nX,nY,nZ,1.0f);

	RECORD_DISPLAYLISTS1(Vertex, vertex)
	if(!displaylist.executeCommands)
		return;

	beginendState.vertices[beginendState.numVertices] = vertex;
	beginendState.fillVertex();
	checkFinishedPrimitive();
}


void glVertex3fv(const float *nVertex)
{
	klVec4 vertex;
	vertex.setFloat(nVertex[0],nVertex[1],nVertex[2],1.0f);

	RECORD_DISPLAYLISTS1(Vertex, vertex)
	if(!displaylist.executeCommands)
		return;

	beginendState.vertices[beginendState.numVertices] = vertex;
	beginendState.fillVertex();
	checkFinishedPrimitive();
}


void glVertex3d(double nX, double nY, double nZ)
{
	klVec4 vertex;
	vertex.setDouble(nX,nY,nZ,1.0);

	RECORD_DISPLAYLISTS1(Vertex, vertex)
	if(!displaylist.executeCommands)
		return;

	beginendState.vertices[beginendState.numVertices] = vertex;
	beginendState.fillVertex();
	checkFinishedPrimitive();
}


void glVertex4fv(const float *nVertex)
{
	klVec4 vertex;
	vertex.setFloat(nVertex);

	RECORD_DISPLAYLISTS1(Vertex, vertex)
	if(!displaylist.executeCommands)
		return;

	beginendState.vertices[beginendState.numVertices] = vertex;
	beginendState.fillVertex();
	checkFinishedPrimitive();
}


void glVertex(const klVec4& nVertex)
{
	beginendState.vertices[beginendState.numVertices] = nVertex;
	beginendState.fillVertex();
	checkFinishedPrimitive();
}


// this method checks wether in there is a
// finished primitive due to glBegin/glEnd calls
void
checkFinishedPrimitive()
{
	// draw the current primitive?
	//
	switch(beginendState.primType)
	{
	case GL_POINTS:
		renderBeginEndPrimitive();
		break;

	case GL_LINES:
		if(beginendState.numVertices==2)
			renderBeginEndPrimitive();
		break;

	case GL_TRIANGLES:
		if(beginendState.numVertices==3)
			renderBeginEndPrimitive();
		break;

	case GL_QUADS:
		if(beginendState.numVertices==4)
			renderBeginEndPrimitive();
		break;

	case GL_LINE_STRIP:
	case GL_LINE_LOOP:
	case GL_TRIANGLE_STRIP:
	case GL_QUAD_STRIP:
	case GL_TRIANGLE_FAN:
	case GL_POLYGON:
		// these types are rendered when glEnd() is called
		break;
	}
}


void
updateColorMaterial(MATERIAL& nMaterial, const klColor4& nColor)
{
	switch(nMaterial.colorMaterialMode)
	{
	case GL_AMBIENT:
		nMaterial.ambient = nColor;
		lightingCache.updateLightAmbient(nMaterial, lights);
		break;

	case GL_DIFFUSE:
		nMaterial.diffuse = nColor;
		lightingCache.updateLightDiffuse(nMaterial, lights);
		break;

	case GL_AMBIENT_AND_DIFFUSE:
		nMaterial.ambient = nColor;
		nMaterial.diffuse = nColor;
		lightingCache.updateLightAmbient(nMaterial, lights);
		lightingCache.updateLightDiffuse(nMaterial, lights);
		break;

	case GL_SPECULAR:
		nMaterial.specular = nColor;
		lightingCache.updateLightSpecular(nMaterial, lights);
		break;

	case GL_EMISSION:
		nMaterial.emissive = nColor;
		break;
	}
}


void
updateColorMaterial()
{
	if(!colorMaterialEnabled)
		return;

	updateColorMaterial(materialFront, beginendState.currentColor);
	updateColorMaterial(materialBack, beginendState.currentColor);
}


/**
}  // class klContext
*/
