/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/klContext_oglLight.h,v 1.4 2004/01/27 08:17:50 drgoldie Exp $
 *
\**************************************************************************/



/**
class klContext
{
*/


//
// This file holds all opengl functions that deal with
//
//                      light
//

void glLightfv(GLenum nLight, GLenum nSelect, const GLfloat* nValues)
{
	klVec4 values;
	values.setFloat(nValues);

	RECORD_DISPLAYLISTS3(Lightv, nLight,nSelect,values)
	if(!displaylist.executeCommands)
		return;

	glLightv(nLight, nSelect, values);
}


void glLightxv(GLenum nLight, GLenum nSelect, const GLfixed* nValues)
{
	klVec4 values;
	values.setFixed(nValues);

	RECORD_DISPLAYLISTS3(Lightv, nLight,nSelect,values)
	if(!displaylist.executeCommands)
		return;

	glLightv(nLight, nSelect, values);
}


void glLightv(GLenum nLight, GLenum nSelect, const klVec4& nValues)
{
	klVec4 vec4;

	nLight -= GL_LIGHT0;

	if(nLight>=MAX_LIGHTS)
		return;

	switch(nSelect)
	{
	case GL_AMBIENT:
		lights[nLight].ambient = nValues;
		lightingCache.updateLightAmbient(materialFront, lights[nLight]);
		lightingCache.updateLightAmbient(materialBack, lights[nLight]);
		return;

	case GL_DIFFUSE:
		lights[nLight].diffuse = nValues;
		lightingCache.updateLightDiffuse(materialFront, lights[nLight]);
		lightingCache.updateLightDiffuse(materialBack, lights[nLight]);
		return;

	case GL_SPECULAR:
		lights[nLight].specular = nValues;
		lightingCache.updateLightSpecular(materialFront, lights[nLight]);
		lightingCache.updateLightSpecular(materialBack, lights[nLight]);
		return;

	case GL_POSITION:
	case GL_SPOT_DIRECTION:
		if(nValues[3]==0)
		{
			vec4 = nValues;
			vec4.setInt(3, 1);

			checkModelProjMatrix();
			lights[nLight].position.transform(modelProjMatrixInvTrans, vec4);
			lights[nLight].position.divideByW();			// normalizing
			lights[nLight].position.setInt(3, 0);
		}
		else
		{
			vec4 = nValues;

			checkModelProjMatrix();
			lights[nLight].position.transform(modelProjMatrix, vec4);
		}
		return;
	}
}

void glLightModeli(GLenum nParam, GLint nValue)
{
	klFloat v;
	v.setInt(nValue);

	RECORD_DISPLAYLISTS2(LightModel, nParam,v)
	if(!displaylist.executeCommands)
		return;

	glLightModel(nParam, v);
}


void glLightModelf(GLenum nParam, GLfloat nValue)
{
	klFloat v;
	v.setFloat(nValue);

	RECORD_DISPLAYLISTS2(LightModel, nParam,v)
	if(!displaylist.executeCommands)
		return;

	glLightModel(nParam, v);
}


void glLightModelx(GLenum nParam, GLfixed nValue)
{
	klFloat v;
	v.setFixed(nValue);

	RECORD_DISPLAYLISTS2(LightModel, nParam,v)
	if(!displaylist.executeCommands)
		return;

	glLightModel(nParam, v);
}


void glLightModel(GLenum nParam, const klFloat& nValue)
{
	switch(nParam)
	{
	case GL_LIGHT_MODEL_LOCAL_VIEWER:
		lightModel.localViewer = (nValue == 0);
		return;

	case GL_LIGHT_MODEL_TWO_SIDE:
		lightModel.twoSided = (nValue != 0);
		return;
	}
}


void glLightModelfv(GLenum nParam, const GLfloat* nValues)
{
	klVec4 values;
	values.setFloat(nValues);			// nValues could contain only one value, but that should be no real problem

	RECORD_DISPLAYLISTS2(LightModelv, nParam,values)
	if(!displaylist.executeCommands)
		return;

	glLightModelv(nParam, values);
}


void glLightModelxv(GLenum nParam, const GLfixed* nValues)
{
	klVec4 values;
	values.setFixed(nValues);			// nValues could contain only one value, but that should be no real problem

	RECORD_DISPLAYLISTS2(LightModelv, nParam,values)
	if(!displaylist.executeCommands)
		return;

	glLightModelv(nParam, values);
}


void glLightModelv(GLenum nParam, const klVec4& nValues)
{
	switch(nParam)
	{
	case GL_LIGHT_MODEL_AMBIENT:
		lightModel.ambient = nValues;
		lightingCache.updateModelAmbient(materialFront, lightModel);
		lightingCache.updateModelAmbient(materialBack, lightModel);
		return;

	case GL_LIGHT_MODEL_LOCAL_VIEWER:
	case GL_LIGHT_MODEL_TWO_SIDE:
		glLightModel(nParam, nValues[0]);
		return;
	}
}


void glShadeModel(GLenum nModel)
{
	RECORD_DISPLAYLISTS1(ShadeModel, nModel)
	if(!displaylist.executeCommands)
		return;

	if(tweak.forceFlatShading)
		smoothShadingEnabled = false;
	else
		smoothShadingEnabled = (nModel==GL_SMOOTH);
}


/**
}  // class klContext
*/

