/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/klContext_oglMaterial.h,v 1.3 2004/01/27 08:17:50 drgoldie Exp $
 *
\**************************************************************************/



/**
class klContext
{
*/


//
// This file holds all opengl functions that deal with
//
//                      materials
//

void glMaterialf(GLenum nSide, GLenum nSelect, GLfloat nValue)
{
	klFloat value;
	value.setFloat(nValue);

	RECORD_DISPLAYLISTS3(Material, nSide, nSelect, value)
	if(!displaylist.executeCommands)
		return;

	glMaterial(nSide, nSelect, value);
}


void glMaterialx(GLenum nSide, GLenum nSelect, GLfixed nValue)
{
	klFloat value;
	value.setFixed(nValue);

	RECORD_DISPLAYLISTS3(Material, nSide, nSelect, value)
	if(!displaylist.executeCommands)
		return;

	glMaterial(nSide, nSelect, value);
}


void glMaterial(GLenum nSide, GLenum nSelect, const klFloat& nValue)
{
	if(nSelect!=GL_SHININESS)
		return;

	switch(nSide)
	{
	case GL_FRONT:
		materialFront.shininess = nValue;
		break;

	case GL_BACK:
		materialBack.shininess = nValue;
		break;

	case GL_FRONT_AND_BACK:
		materialBack.shininess = materialFront.shininess = nValue;
		break;
	}
}


void glMaterialfv(GLenum nSide, GLenum nSelect, const GLfloat* nValues)
{
	klVec4 values;
	values.setFloat(nValues);

	RECORD_DISPLAYLISTS3(Materialv, nSide, nSelect, values)
	if(!displaylist.executeCommands)
		return;

	glMaterialv(nSide, nSelect, values);
}


void glMaterialiv(GLenum nSide, GLenum nSelect, const GLint* nValues)
{
	klVec4 values;
	values.setInt1(nValues);

	RECORD_DISPLAYLISTS3(Materialv, nSide, nSelect, values)
	if(!displaylist.executeCommands)
		return;

	glMaterialv(nSide, nSelect, values);
}


void glMaterialxv(GLenum nSide, GLenum nSelect, const GLfixed* nValues)
{
	klVec4 values;
	values.setFixed(nValues);

	RECORD_DISPLAYLISTS3(Materialv, nSide, nSelect, values)
	if(!displaylist.executeCommands)
		return;

	glMaterialv(nSide, nSelect, values);
}


void glMaterialv(GLenum nSide, GLenum nSelect, const klVec4& nValues)
{
	if(nSide==GL_FRONT_AND_BACK)
	{
		glMaterialv(GL_FRONT, nSelect, nValues);
		glMaterialv(GL_BACK, nSelect, nValues);
		return;
	}

	bool isFront = nSide==GL_FRONT;
	MATERIAL& mat = isFront ? materialFront : materialBack;

	switch(nSelect)
	{
	case GL_AMBIENT:
		mat.ambient = nValues;
		lightingCache.updateModelAmbient(mat, lightModel);
		lightingCache.updateLightAmbient(mat, lights);
		return;

	case GL_DIFFUSE:
		mat.diffuse = nValues;
		lightingCache.updateLightDiffuse(mat, lights);
		return;

	case GL_SPECULAR:
		mat.specular = nValues;
		lightingCache.updateLightSpecular(mat, lights);
		return;

	case GL_EMISSION:
		mat.emissive = nValues;
		return;

	case GL_SHININESS:
		mat.shininess = nValues[0];
		return;

	case GL_AMBIENT_AND_DIFFUSE:
		mat.ambient = nValues;
		lightingCache.updateModelAmbient(mat, lightModel);
		lightingCache.updateLightAmbient(mat, lights);
		mat.diffuse = nValues;
		lightingCache.updateLightDiffuse(mat, lights);
		return;
	}
}

void glColorMaterial(GLenum nSide, GLenum nMode)
{
	RECORD_DISPLAYLISTS2(ColorMaterial, nSide, nMode)
	if(!displaylist.executeCommands)
		return;

	switch(nSide)
	{
	case GL_FRONT:
		materialFront.colorMaterialMode = nMode;
		break;

	case GL_BACK:
		materialBack.colorMaterialMode = nMode;
		break;

	case GL_FRONT_AND_BACK:
		materialFront.colorMaterialMode = materialBack.colorMaterialMode = nMode;
		break;
	}
}


void glPolygonMode(GLenum nSide, GLenum nPoly)
{
	RECORD_DISPLAYLISTS2(PolygonMode, nSide, nPoly)
	if(!displaylist.executeCommands)
		return;

	switch(nSide)
	{
	case GL_FRONT:
		materialFront.polyMode = nPoly;
		return;

	case GL_BACK:
		materialBack.polyMode = nPoly;
		return;

	case GL_FRONT_AND_BACK:
		materialFront.polyMode = materialBack.polyMode = nPoly;
		return;
	}
}


void glGetMaterialfv(GLenum nSide, GLenum nSelect, GLfloat* nValues)
{
	MATERIAL& mat = (nSide==GL_FRONT) ? materialFront : materialBack;

	switch(nSelect)
	{
	case GL_AMBIENT:
		mat.ambient.getFloat(nValues);
		return;

	case GL_DIFFUSE:
		mat.diffuse.getFloat(nValues);
		return;

	case GL_SPECULAR:
		mat.specular.getFloat(nValues);
		return;

	case GL_EMISSION:
		mat.emissive.getFloat(nValues);
		return;

	case GL_SHININESS:
		*nValues = mat.shininess.getFloat();
		return;
	}
}


void glGetMaterialiv(GLenum nSide, GLenum nSelect, GLint* nValues)
{
	MATERIAL& mat = (nSide==GL_FRONT) ? materialFront : materialBack;

	switch(nSelect)
	{
	case GL_AMBIENT:
		mat.ambient.getInt1(nValues);
		return;

	case GL_DIFFUSE:
		mat.diffuse.getInt1(nValues);
		return;

	case GL_SPECULAR:
		mat.specular.getInt1(nValues);
		return;

	case GL_EMISSION:
		mat.emissive.getInt1(nValues);
		return;

	case GL_SHININESS:
		*nValues = mat.shininess.getInt();
		return;
	}
}


void glGetMaterialxv(GLenum nSide, GLenum nSelect, GLfixed* nValues)
{
	MATERIAL& mat = (nSide==GL_FRONT) ? materialFront : materialBack;

	switch(nSelect)
	{
	case GL_AMBIENT:
		mat.ambient.getFixed(nValues);
		return;

	case GL_DIFFUSE:
		mat.diffuse.getFixed(nValues);
		return;

	case GL_SPECULAR:
		mat.specular.getFixed(nValues);
		return;

	case GL_EMISSION:
		mat.emissive.getFixed(nValues);
		return;

	case GL_SHININESS:
		*nValues = mat.shininess.getFixed();
		return;
	}
}


/**
}  // class klContext
*/
