/**************************************************************************\
 *
 *  This file is part of the Klimt library.
 *  Copyright (C) 2003 by IMS, Vienna University of Technology.
 *  All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  ("GPL") version 2 as published by the Free Software Foundation.
 *  See the file LICENSE.GPL at the root directory of this source
 *  distribution for additional information about the GNU GPL.
 *  For the full GPL license see
 *  <URL:http://www.gnu.org/copyleft/gpl.html>
 *
 *  For using Klimt with software that can not be combined with the
 *  GNU GPL, and for taking advantage of the additional benefits of
 *  our support services, please contact IMS about acquiring a
 *  Klimt Professional Edition License.
 *
 *  Contact: <mailto:klimt@studierstube.org>
 *  See <URL:http://www.studierstube.org/klimt>
 *  for more information.
 *
 *  Vienna University of Technology
 *  Institute for Software Technology and Interactive Systems
 *  Interactive Media Systems Group
 *  Favoritenstrasse 9-11/188/2
 *  A-1040 Vienna, Austria
 *  <URL:http://www.ims.tuwien.ac.at>.
 *
 **************************************************************************
 *
 * $Header: /cvsroot/klimt/klimt/klimt/src/klRasterizer_Settings.h,v 1.5 2004/02/10 18:19:30 drgoldie Exp $
 *
\**************************************************************************/


#ifndef __KLRASTERIZER_SETTINGS_HEADERFILE__
#define __KLRASTERIZER_SETTINGS_HEADERFILE__


// Settings for the rasterizer object
//

//
// TODO: lots of this stuff here is no longer needed with the new rasterizer
//

enum RASTER_FUNC_CONSTANTS
{
	RASTER_BASE_ZWRITE = 1,
	RASTER_BASE_ZTEST = 2,
	RASTER_BASE_COLOR = 14,
	RASTER_BASE_FOG = 84,
	RASTER_BASE_BLENDING = 168,
	RASTER_NUM_BLENDING = 6,
	NUM_SPANFUNCS = RASTER_BASE_BLENDING * RASTER_NUM_BLENDING
};

enum COLOR_MASK
{
	COLOR_MASK_RED = 1,
	COLOR_MASK_GREEN = 2,
	COLOR_MASK_BLUE = 4,
	COLOR_MASK_ALPHA = 8,
	COLOR_MASK_RGB = COLOR_MASK_RED|COLOR_MASK_GREEN|COLOR_MASK_BLUE
};

enum RASTER_POLYGONMODE
{
	RASTER_POINTS = 1,
	RASTER_LINES = 2,
	RASTER_FILL = 3
};


enum RASTER_MODE_ZWRITE
{
	RASTER_ZWRITE_OFF = 0,
	RASTER_ZWRITE_ON = 1
};

enum RASTER_MODE_ZTEST
{
	RASTER_ZTEST_NEVER = -1,
	RASTER_ZTEST_LESS = 0,
	RASTER_ZTEST_LEQUAL = 1,
	RASTER_ZTEST_EQUAL = 2,
	RASTER_ZTEST_GREATER = 3,
	RASTER_ZTEST_NOTEQUAL = 4,
	RASTER_ZTEST_GEQUAL = 5,
	RASTER_ZTEST_ALWAYS = 6
};

enum RASTER_MODE_COLOR
{
	RASTER_COLOR_OFF = 0,
	RASTER_COLOR_FLAT = 1,
	RASTER_COLOR_GOURAUD = 2,
	RASTER_COLOR_TEX = 3,
	RASTER_COLOR_TEXFLAT = 4,
	RASTER_COLOR_TEXGOURAUD = 5
};

enum RASTER_MODE_TEXENV
{
	RASTER_TEXENV_DECAL = 0,
	RASTER_TEXENV_MODULATE = 1
};

enum RASTER_MODE_FOG
{
	RASTER_FOG_OFF = 0,
	RASTER_FOG_ON = 1
};

enum RASTER_MODE_BLEND
{
	RASTER_BLEND_OFF = 0,
	RASTER_BLEND_ADD = 1,
	RASTER_BLEND_ADDHALF = 2,
	RASTER_BLEND_ALPHA_VERTEX  = 3,
	RASTER_BLEND_ALPHA_TEX = 4,
	RASTER_BLEND_ALPHA_TEXVERTEX = 5
};


struct klRasterizer_Settings
{
	//bool doTex() const  {  return color>=RASTER_COLOR_TEX;  }

	bool doTex() const  {  return numtexstages>0;  }

	RASTER_POLYGONMODE	polyMode;

	// TODO: some of these are no longer needed with the new rasterizer.
	//       we'll get rid of this when we abandon the old rasterizer.
	RASTER_MODE_ZWRITE	zwrite;
	RASTER_MODE_ZTEST	ztest;
	//RASTER_MODE_COLOR	color;
	RASTER_MODE_TEXENV	texenv;
	RASTER_MODE_FOG		fog;
	//RASTER_MODE_BLEND	blendMode;

	int					numtexstages;

	bool				blendEnabled;
	int					blendSrc, blendDst;

	unsigned int		colorMask;
};


struct klMipMapLevel_Info
{
	klMipMapLevel_Info() :  width(0), height(0), border(0),
							 format(GL_RGB), type(GL_TEXTURE_2D), pixelType(GL_UNSIGNED_BYTE)  {}

	unsigned int	width,height;
	int				border;
	GLenum			format;
	GLenum			type;
	GLenum			pixelType;
	int				internalFormat;
};

#endif //__KLRASTERIZER_SETTINGS_HEADERFILE__
