#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "gl/gl.h"
#include "gl/glu.h"
#include "glut.h"

float f1 = 45.0f;
float f2 = 65.0f;

void idle();

int main(int argc, char *argv[])
{
    int done;

    EGLDisplay display = eglGetDisplay(EGL_DEFAULT_DISPLAY);
    EGLint major, minor;

    eglInitialize(display, &major, &minor);

    EGLSurface sfc = eglCreateWindowSurface(display, 0, 0, 0);
    EGLContext ctx = eglCreateContext(display, 0, 0, 0);
    eglMakeCurrent(display, sfc, sfc, ctx);

    // general setup
    //
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(45.0f,(float)320/(float)240,0.1f,20.0f);

    glMatrixMode(GL_MODELVIEW);
    glClearColor(0.0f, 0.0f, 0.0f, 0.0f);

    done = 0;

    while(!done){
	    idle();
    }

    return 0;
}

void idle()
{
//	if(mode==MODE_SGL)
//		sglSetColorBuffer(getBackBuffer()->getPixels());

	float l0Amb[] = { 0.8f, 0.8f, 0.8f, 1.0f };
	float lPos[4] = { 0.0f, 0.0f, 1.0f, 0.0f };

	glClearColor(0.0f, 0.5f, 1.0f,0.0f);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glLightfv(GL_LIGHT0, GL_POSITION, lPos);
	glMaterialfv(GL_FRONT, GL_DIFFUSE, l0Amb);

	glLoadIdentity();									// Reset The View
	glTranslatef(0.0f,-0.0f,-6.0f);

	glRotatef(f1,1.0f,0.0f,0.0f);
	glRotatef(f2,0.0f,1.0f,0.0f);

	glDisable(GL_DEPTH_TEST);							// Disable z-test
	glDepthMask(GL_FALSE);

	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);

	glCullFace(GL_BACK);
	glShadeModel(GL_FLAT);
	glEnable(GL_CULL_FACE);

	glColor3f(1.0f, 1.0f, 1.0f);
	glutSolidCube(2.0);

	f1+=0.3f;
	f2+=0.5f;


	// this will not work on 3d-hardware accelerated devices...
//	if(sglGetColorBuffer())
//	{
//		Image* bb = Image::createFromPixelBuffer(320,240, (unsigned short*)sglGetColorBuffer(), false);
//		bb->drawTextEx(2, bb->getHeight()-font->getHeight()-2, font, true, "FPS: %.1f", getFPS());
//		delete bb;
//	}

//	if(mode==MODE_WGL)
//		SwapBuffers(hdc);
//	if(mode==MODE_EGL)
//	{
		EGLSurface surface = eglGetCurrentSurface(EGL_DRAW);
		EGLDisplay display = eglGetCurrentDisplay();

		eglSwapBuffers(display, surface);
//	}
}

