#include "simple.h"

#include <qpe/qpeapplication.h>

#include <qtimer.h>

#include <qdatetime.h>



#include <gl/gl.h>

#include <gl/glu.h>

#include <glut.h>





simple::MODE	mode = simple::MODE_EGL;



simple::simple(QWidget* parent, const char* name): QWidget( parent, name )

{

	f1 = 45.0f;

	f2 = 65.0f;

	hdc = NULL;

	hWnd = this;

	backBuffer = new ZSurface(240,320);

	font = new ZFont(QFont("fixed",10),QColor(255,255,255),QColor(0,0,0));

	libstring = new QString("libKlimt.so.0.5.0");

}



void

simple::startup()

{

	if(mode==MODE_WGL)

	{

		qFatal("MODE_WGL not supported under QTE");

	}



	if(mode==MODE_KL)

	{

		klCreateDefaultContext();

		// rotate the hWnd

		backBuffer->create(320,240);

  		klSetBufferSize(320,240);

	}

	

	if(mode==MODE_EGL)

	{

		EGLDisplay display = eglGetDisplay(EGL_DEFAULT_DISPLAY);

		EGLint major, minor;

		eglInitialize(display, &major, &minor);

		EGLSurface sfc = eglCreateWindowSurface(display, 0, hWnd, 0);

		EGLContext ctx = eglCreateContext(display, 0, 0, 0);

		eglMakeCurrent(display, sfc, sfc, ctx);

	}



	// general setup

	//

	glMatrixMode(GL_PROJECTION);

	glLoadIdentity();

	gluPerspective(45.0f,(float)320/(float)240,0.1f,20.0f);



	glMatrixMode(GL_MODELVIEW);

	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);

	// use QTimer as our heartbeat method

	connect( &iTimer, SIGNAL(timeout()), this, SLOT(renderFrame()));

	iTimer.start(30);

}



void

simple::renderFrame()

{

	if(mode==MODE_KL)

		klSetColorBuffer(backBuffer->bits());



	float l0Amb[] = { 0.8f, 0.8f, 0.8f, 1.0f };

	float lPos[4] = { 0.0f, 0.0f, 1.0f, 0.0f };



	glClearColor(0.0f, 0.5f, 1.0f,0.0f);

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer



	glMatrixMode(GL_MODELVIEW);

	glLoadIdentity();

	glLightfv(GL_LIGHT0, GL_POSITION, lPos);

	glMaterialfv(GL_FRONT, GL_DIFFUSE, l0Amb);



	glLoadIdentity();									// Reset The View

	glTranslatef(0.0f,-0.0f,-6.0f);



	glRotatef(f1,1.0f,0.0f,0.0f);

	glRotatef(f2,0.0f,1.0f,0.0f);



	glDisable(GL_DEPTH_TEST);							// Disable z-test

	glDepthMask(GL_FALSE);



	glEnable(GL_LIGHTING);

	glEnable(GL_LIGHT0);



	glCullFace(GL_BACK);

	glShadeModel(GL_FLAT);

	glEnable(GL_CULL_FACE);



	glColor3f(1.0f, 1.0f, 1.0f);

	glutSolidCube(2.0);



	f1+=0.3f;

	f2+=0.5f;



	if (mode==MODE_KL) {

		QDirectPainter dst(hWnd);

		backBuffer->drawText(10,10,*libstring,font);

		ZSurface::bitBlit(&dst,backBuffer,ZSurface::Z270);

	}

	

	if(mode==MODE_WGL)

		qFatal("MODE_WGL not supported under QTE");

	

	if(mode==MODE_EGL)

	{

		EGLSurface surface = eglGetCurrentSurface(EGL_DRAW);

		EGLDisplay display = eglGetCurrentDisplay();

		eglSwapBuffers(display, surface);

	}

}



void  simple::enableFullscreen()

{

   // Make sure size is correct

   setFixedSize(qApp->desktop()->size());

   // This call is needed because showFullScreen won't work

   // correctly if the widget already considers itself to be fullscreen.

   showNormal();

   // This is needed because showNormal() forcefully changes the window

   // style to WSTyle_TopLevel.

   reparent(0, WStyle_Customize | WStyle_NoBorder, QPoint(0,0));

   // Enable fullscreen.

   showFullScreen();

}



void  simple::resizeEvent(QResizeEvent *)

{

   if ( size() != qApp->desktop()->size() )

   {

      // Widget is not the correct size, so do the fullscreen magic

      enableFullscreen();

   }



}

void  simple::focusInEvent(QFocusEvent *)

{

   // Always do it here, no matter the size.

   enableFullscreen();

}



void simple::keyPressEvent ( QKeyEvent * )

{

   qApp->quit();

}



int main( int argc, char **argv )

{

    QPEApplication a(argc,argv);



    simple w;

    a.showMainWidget( &w );

    w.resize( qApp->desktop()->size() );

	w.startup();

    return a.exec();

}

