

#include "simple.h"
#include "resource.h"

#include <pocketknife/ImageTool.h>

#include <gl/gl.h>
#include <gl/glu.h>
#include <glut.h>


using namespace IMS;

//#define REAL_OPENGL

bool setPixelFormat(HDC hDC)
{
#ifdef REAL_OPENGL
	GLuint		PixelFormat;			// Holds The Results After Searching For A Match

	static	PIXELFORMATDESCRIPTOR pfd=				// pfd Tells Windows How We Want Things To Be
	{
		sizeof(PIXELFORMATDESCRIPTOR),				// Size Of This Pixel Format Descriptor
		1,											// Version Number
		PFD_DRAW_TO_WINDOW |						// Format Must Support Window
		PFD_SUPPORT_OPENGL |						// Format Must Support OpenGL
		PFD_DOUBLEBUFFER,							// Must Support Double Buffering
		PFD_TYPE_RGBA,								// Request An RGBA Format
		16,											// Select Our Color Depth
		0, 0, 0, 0, 0, 0,							// Color Bits Ignored
		0,											// No Alpha Buffer
		0,											// Shift Bit Ignored
		0,											// No Accumulation Buffer
		0, 0, 0, 0,									// Accumulation Bits Ignored
		16,											// 16Bit Z-Buffer (Depth Buffer)  
		0,											// No Stencil Buffer
		0,											// No Auxiliary Buffer
		PFD_MAIN_PLANE,								// Main Drawing Layer
		0,											// Reserved
		0, 0, 0										// Layer Masks Ignored
	};

	if (!(PixelFormat=ChoosePixelFormat(hDC,&pfd)))	// Did Windows Find A Matching Pixel Format?
		return false;

	if(!SetPixelFormat(hDC,PixelFormat,&pfd))		// Are We Able To Set The Pixel Format?
		return false;

	return true;
#else
	return true;
#endif
}



simple::MODE	mode = simple::MODE_KL;

int                                                                                           
WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow)
{
	simple app;

	if(!app.init(hInstance, nCmdShow, mode==simple::MODE_KL))		// evt. do not let PocketKnife provide a backbuffer,
		return FALSE;												// we might want SoftGL to do that...

	return (int)app.run();
}


simple::simple()
{
	f1 = 45.0f;
	f2 = 65.0f;
	hdc = NULL;
}


void
simple::startup()
{
#ifdef _WIN32_WCE										// switch to fullscreen and
	::SHFullScreen(hWnd, SHFS_HIDESTARTICON);			// remove all buttons, bar, etc...
	::SHFullScreen(hWnd, SHFS_HIDESIPBUTTON);
	::SHFullScreen(hWnd, SHFS_HIDETASKBAR);
	::MoveWindow(hWnd, 0, 0, 240, 320, TRUE);
	::ShowWindow(hWnd, SW_SHOW);
	::UpdateWindow(hWnd);
#endif //_WIN32_WCE

	unsigned char* pixels = NULL;

	font = Font::load(IDB_FONT_6x8, 6);
	font->setTransparentColor(255,0,255);
	font2 = Font::load(IDB_FONT_8x12, 8);
	font2->setTransparentColor(255,0,255);

	if(mode==MODE_WGL)
	{
		hdc = ::GetDC(hWnd);
		setPixelFormat(hdc);
		HGLRC rc = wglCreateContext(hdc);
		wglMakeCurrent(hdc, rc);
	}

	if(mode==MODE_EGL)
	{
		EGLDisplay display = eglGetDisplay(EGL_DEFAULT_DISPLAY);
		EGLint major, minor;

		eglInitialize(display, &major, &minor);

		EGLSurface sfc = eglCreateWindowSurface(display, 0, hWnd, 0);

		//eglDestroySurface(display, sfc);
		//sfc = eglCreateWindowSurface(display, 0, hWnd, 0);

		EGLContext ctx = eglCreateContext(display, 0, 0, 0);
		eglMakeCurrent(display, sfc, sfc, ctx);
	}

	if(mode==MODE_KL)
	{
		klCreateDefaultContext();
		klSetBufferSize(320,240);
	}

	// general setup
	//
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(45.0f,(float)320/(float)240,0.1f,20.0f);

	glMatrixMode(GL_MODELVIEW);
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);

	glEnable(GL_NORMALIZE);


	dplList = 0;

	glNewList(dplList, GL_COMPILE);
		glRotatef(90.0f,1.0f,0.0f,0.0f);
		glutSolidCube(2.0);
	glEndList();

	glNewList(dplList, GL_COMPILE);
		glDisable(GL_DEPTH_TEST);							// Disable z-test
		glDepthMask(GL_FALSE);

		glEnable(GL_LIGHTING);
		glEnable(GL_LIGHT0);

		glCullFace(GL_BACK);
		glShadeModel(GL_FLAT);
		glEnable(GL_CULL_FACE);

		glColor3f(1.0f, 1.0f, 1.0f);
		glutSolidCube(2.0);
		glDisable(GL_CULL_FACE);
	glEndList();
}


void
simple::shutDown()
{
	if(mode==MODE_WGL)
	{
		HGLRC rc = wglGetCurrentContext();
		if(rc)
			wglDeleteContext(rc);
	}
	else
	if(mode==MODE_EGL)
	{
		EGLDisplay display = eglGetDisplay(EGL_DEFAULT_DISPLAY);
		EGLSurface sfc = eglGetCurrentSurface(EGL_TRUE);
		eglDestroySurface(display, sfc);
	}

	this->Application::shutDown();
}


void
simple::onButtonPressed(Input::BUTTON nButton)
{
	shutDown();
}


void
simple::onStylusDown(int nX, int nY)
{
	if(nX<30 && nY<30 && klGetColorBuffer())
	{
		Image* bb = Image::createFromPixelBuffer(320,240, (unsigned short*)klGetColorBuffer(), false);
		ImageTool::saveAsTGA(bb, "dump.tga");
		delete bb;
	}
	else
		shutDown();
}


void
simple::renderFrame()
{
	if(mode==MODE_KL)
		klSetColorBuffer(getBackBuffer()->getPixels());

	float l0Amb[] = { 0.8f, 0.8f, 0.8f, 1.0f };
	float lPos[4] = { 0.0f, 0.0f, 1.0f, 0.0f };

	//glNormal3f(200.0f, 100.0f, 100.0f);

	glClearColor(0.0f, 0.5f, 1.0f,0.0f);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glLightfv(GL_LIGHT0, GL_POSITION, lPos);
	glMaterialfv(GL_FRONT, GL_DIFFUSE, l0Amb);

	glLoadIdentity();									// Reset The View
	glTranslatef(0.0f,-0.0f,-6.0f);

	glRotatef(f1,1.0f,0.0f,0.0f);
	glRotatef(f2,0.0f,1.0f,0.0f);

	/*glDisable(GL_DEPTH_TEST);							// Disable z-test
	glDepthMask(GL_FALSE);

	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);

	glCullFace(GL_BACK);
	glShadeModel(GL_FLAT);
	glEnable(GL_CULL_FACE);*/


	//glColor3f(1.0f, 1.0f, 1.0f);
	//glutSolidCube(2.0);

	glCallList(dplList);


	f1+=0.3f;
	f2+=0.5f;


	// this will not work on 3d-hardware accelerated devices...
	if(klGetColorBuffer())
	{
		Image* bb = Image::createFromPixelBuffer(320,240, (unsigned short*)klGetColorBuffer(), false);
		bb->drawTextEx(2, bb->getHeight()-font->getHeight()-2, font, true, "FPS: %.1f", getFPS());
		delete bb;
	}

	if(mode==MODE_WGL)
		SwapBuffers(hdc);
	if(mode==MODE_EGL)
	{
		EGLSurface surface = eglGetCurrentSurface(EGL_DRAW);
		EGLDisplay display = eglGetCurrentDisplay();

		eglSwapBuffers(display, surface);
	}
}

